/*
 * Decompiled with CFR 0.152.
 */
package xyz.phanta.tconevo.integration.draconicevolution.client;

import com.brandon3055.draconicevolution.api.fusioncrafting.IFusionRecipe;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import mezz.jei.api.gui.IRecipeLayout;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.modifiers.IModifier;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierNBT;
import slimeknights.tconstruct.library.modifiers.TinkerGuiException;
import slimeknights.tconstruct.library.tinkering.Category;
import slimeknights.tconstruct.library.tinkering.TinkersItem;
import slimeknights.tconstruct.library.tools.ToolCore;
import slimeknights.tconstruct.library.traits.ITrait;
import slimeknights.tconstruct.library.utils.TagUtil;
import slimeknights.tconstruct.library.utils.TinkerUtil;
import slimeknights.tconstruct.library.utils.ToolBuilder;
import xyz.phanta.tconevo.init.TconEvoTraits;
import xyz.phanta.tconevo.integration.conarm.ConArmHooks;
import xyz.phanta.tconevo.integration.draconicevolution.DraconicUpgradeRecipe;
import xyz.phanta.tconevo.util.TconReflect;

public class DraconicJeiCoreHooks {
    @Nullable
    private static List<ItemStack> cachedToolStacks;
    @Nullable
    private static List<ItemStack> cachedArmourStacks;

    private static List<ItemStack> getToolStacks() {
        if (cachedToolStacks != null) {
            return cachedToolStacks;
        }
        cachedToolStacks = new ArrayList<ItemStack>();
        for (ToolCore item : TinkerRegistry.getTools()) {
            NBTTagCompound tag = new NBTTagCompound();
            try {
                ToolBuilder.rebuildTool((NBTTagCompound)tag, (TinkersItem)item);
            }
            catch (TinkerGuiException tinkerGuiException) {
                // empty catch block
            }
            TagUtil.setCategories((NBTTagCompound)tag, (Category[])TconReflect.getCategories((TinkersItem)item));
            TconEvoTraits.TRAIT_EVOLVED[0].apply(tag);
            ItemStack stack = new ItemStack((Item)item);
            stack.func_77982_d(tag);
            cachedToolStacks.add(stack);
        }
        return cachedToolStacks;
    }

    private static List<ItemStack> getArmourStacks() {
        if (cachedArmourStacks != null) {
            return cachedArmourStacks;
        }
        cachedArmourStacks = new ArrayList<ItemStack>();
        for (Item item : ConArmHooks.INSTANCE.getArmourItems()) {
            NBTTagCompound tag = new NBTTagCompound();
            try {
                ConArmHooks.INSTANCE.rebuildArmour(tag, item);
            }
            catch (TinkerGuiException tinkerGuiException) {
                // empty catch block
            }
            ItemStack stack = new ItemStack(item);
            ITrait trait = TinkerRegistry.getTrait((String)"tconevo.evolved1_armor");
            if (trait instanceof IModifier) {
                ((IModifier)trait).apply(tag);
            }
            stack.func_77982_d(tag);
            cachedArmourStacks.add(stack);
        }
        return cachedArmourStacks;
    }

    public static void fixFusionRecipe(IRecipeLayout layout, IFusionRecipe recipe) {
        if (!(recipe instanceof DraconicUpgradeRecipe)) {
            return;
        }
        DraconicUpgradeRecipe upgradeRecipe = (DraconicUpgradeRecipe)recipe;
        Modifier mod = upgradeRecipe.getModifier();
        ArrayList<ItemStack> inputStacks = new ArrayList<ItemStack>();
        ArrayList<ItemStack> outputStacks = new ArrayList<ItemStack>();
        for (ItemStack templateStack : ConArmHooks.INSTANCE.isArmourModifierTrait((IModifier)mod) ? DraconicJeiCoreHooks.getArmourStacks() : DraconicJeiCoreHooks.getToolStacks()) {
            NBTTagCompound templateTag = TagUtil.getTagSafe((ItemStack)templateStack);
            if (!TinkerUtil.hasModifier((NBTTagCompound)templateTag, (String)mod.identifier)) continue;
            NBTTagCompound tag = templateTag.func_74737_b();
            NBTTagCompound modTag = TinkerUtil.getModifierTag((NBTTagCompound)tag, (String)mod.identifier);
            ModifierNBT modData = ModifierNBT.readTag((NBTTagCompound)modTag);
            modData.level = upgradeRecipe.getRecipeTier() + 1;
            modData.write(modTag);
            ItemStack inputStack = new ItemStack(templateStack.func_77973_b());
            inputStack.func_77982_d(tag.func_74737_b());
            inputStacks.add(inputStack);
            ++modData.level;
            modData.write(modTag);
            ItemStack outputStack = new ItemStack(templateStack.func_77973_b());
            outputStack.func_77982_d(tag);
            outputStacks.add(outputStack);
        }
        layout.getItemStacks().set(0, inputStacks);
        layout.getItemStacks().set(1, outputStacks);
    }
}

