/*
 * Decompiled with CFR 0.152.
 */
package xyz.phanta.tconevo.integration.draconicevolution.client;

import com.brandon3055.draconicevolution.client.handler.HudHandler;
import com.brandon3055.draconicevolution.items.armor.ICustomArmor;
import io.github.phantamanta44.libnine.util.helper.MirrorUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.items.IItemHandler;
import xyz.phanta.tconevo.capability.EnergyShield;
import xyz.phanta.tconevo.handler.EnergyShieldHandler;
import xyz.phanta.tconevo.integration.baubles.BaublesHooks;

public class DraconicShieldHudHandler {
    private static final MirrorUtils.IField<Float> fArmorStatsFadeOut = MirrorUtils.reflectField(HudHandler.class, (String)"armorStatsFadeOut");
    private static final MirrorUtils.IField<Boolean> fShowShieldHud = MirrorUtils.reflectField(HudHandler.class, (String)"showShieldHud");
    private static final MirrorUtils.IField<Float> fMaxShieldPoints = MirrorUtils.reflectField(HudHandler.class, (String)"maxShieldPoints");
    private static final MirrorUtils.IField<Float> fShieldPoints = MirrorUtils.reflectField(HudHandler.class, (String)"shieldPoints");
    private static final MirrorUtils.IField<Integer> fShieldPercentCharge = MirrorUtils.reflectField(HudHandler.class, (String)"shieldPercentCharge");
    private static final MirrorUtils.IField<Float> fShieldEntropy = MirrorUtils.reflectField(HudHandler.class, (String)"shieldEntropy");
    private static final MirrorUtils.IField<Integer> fRfCharge = MirrorUtils.reflectField(HudHandler.class, (String)"rfCharge");
    private static final MirrorUtils.IField<Long> fRfTotal = MirrorUtils.reflectField(HudHandler.class, (String)"rfTotal");
    private boolean cachedDeStats = false;
    private float deMaxShieldPoints = 0.0f;
    private float deShieldPoints = 0.0f;
    private float deShieldEntropoy = 0.0f;
    private long deRfTotal = 0L;
    private float augMaxShieldPoints = 0.0f;
    private float augShieldPoints = 0.0f;
    private float augShieldEntropy = 0.0f;
    private long augRfTotal = 0L;

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onClientTickLater(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            if (player == null) {
                return;
            }
            List<EnergyShield> shields = EnergyShieldHandler.collectArmourShields(player.field_71071_by);
            if (shields.isEmpty()) {
                this.cachedDeStats = false;
                return;
            }
            float shieldPoints = 0.0f;
            float shieldCap = 0.0f;
            float entropy = 0.0f;
            long energy = 0L;
            long energyCap = 0L;
            List<ItemStack> deArmour = DraconicShieldHudHandler.findDeArmourPieces((EntityPlayer)player);
            if (!deArmour.isEmpty()) {
                shieldPoints = ((Float)fShieldPoints.get(null)).floatValue();
                shieldCap = ((Float)fMaxShieldPoints.get(null)).floatValue();
                entropy = ((Float)fShieldEntropy.get(null)).floatValue();
                energy = (Long)fRfTotal.get(null);
                for (ItemStack stack : deArmour) {
                    if (!stack.hasCapability(CapabilityEnergy.ENERGY, null)) continue;
                    energyCap += (long)((IEnergyStorage)Objects.requireNonNull(stack.getCapability(CapabilityEnergy.ENERGY, null))).getMaxEnergyStored();
                }
            }
            this.deMaxShieldPoints = shieldCap;
            this.deShieldPoints = shieldPoints;
            this.deShieldEntropoy = entropy;
            this.deRfTotal = energy;
            this.cachedDeStats = true;
            entropy *= (float)deArmour.size();
            for (EnergyShield shield : shields) {
                shieldPoints += shield.getShieldPoints();
                shieldCap += shield.getShieldCapacity();
                entropy += shield.getEntropy();
                energy += (long)shield.getEnergyStored();
                energyCap += (long)shield.getMaxEnergyStored();
            }
            if (shieldCap != this.augMaxShieldPoints || shieldPoints != this.augShieldPoints || (entropy /= (float)(deArmour.size() + shields.size())) != this.augShieldEntropy || energy != this.augRfTotal) {
                fArmorStatsFadeOut.set(null, (Object)Float.valueOf(5.0f));
                fShowShieldHud.set(null, (Object)true);
            } else if (((Float)fArmorStatsFadeOut.get(null)).floatValue() > 0.0f) {
                fShowShieldHud.set(null, (Object)true);
            }
            this.augMaxShieldPoints = shieldCap;
            fMaxShieldPoints.set(null, (Object)Float.valueOf(this.augMaxShieldPoints));
            this.augShieldPoints = shieldPoints;
            fShieldPoints.set(null, (Object)Float.valueOf(this.augShieldPoints));
            fShieldPercentCharge.set(null, (Object)((int)(shieldPoints / shieldCap * 100.0f)));
            this.augShieldEntropy = entropy;
            fShieldEntropy.set(null, (Object)Float.valueOf(this.augShieldEntropy));
            fRfCharge.set(null, (Object)((int)((float)energy / (float)energyCap * 100.0f)));
            this.augRfTotal = energy;
            fRfTotal.set(null, (Object)this.augRfTotal);
        }
    }

    private static List<ItemStack> findDeArmourPieces(EntityPlayer player) {
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        for (ItemStack stack : player.field_71071_by.field_70460_b) {
            if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ICustomArmor)) continue;
            result.add(stack);
        }
        IItemHandler baublesInv = BaublesHooks.INSTANCE.getBaublesInventory(player);
        if (baublesInv != null) {
            for (int i = 0; i < baublesInv.getSlots(); ++i) {
                ItemStack stack = baublesInv.getStackInSlot(i);
                if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ICustomArmor)) continue;
                result.add(stack);
            }
        }
        return result;
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onClientTickSooner(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END && this.cachedDeStats) {
            fMaxShieldPoints.set(null, (Object)Float.valueOf(this.deMaxShieldPoints));
            fShieldPoints.set(null, (Object)Float.valueOf(this.deShieldPoints));
            fShieldEntropy.set(null, (Object)Float.valueOf(this.deShieldEntropoy));
            fRfTotal.set(null, (Object)this.deRfTotal);
        }
    }
}

