/*
 * Decompiled with CFR 0.152.
 */
package xyz.phanta.tconevo.integration.forestry;

import forestry.api.recipes.IFabricatorRecipe;
import io.github.phantamanta44.libnine.util.collection.NonNullLists;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;

public abstract class ThermionicCastingRecipe
implements IFabricatorRecipe {
    private final FluidStack liquid;
    private final ItemStack output;

    public ThermionicCastingRecipe(FluidStack liquid, ItemStack output) {
        this.liquid = liquid;
        this.output = output;
    }

    public FluidStack getLiquid() {
        return this.liquid;
    }

    public ItemStack getRecipeOutput() {
        return this.output;
    }

    public static class NonConsuming
    extends ThermionicCastingRecipe {
        private final ItemStack cast;

        public NonConsuming(ItemStack cast, FluidStack liquid, ItemStack output) {
            super(liquid, output);
            this.cast = cast;
        }

        public NonNullList<NonNullList<ItemStack>> getIngredients() {
            return NonNullLists.emptyNonnullList();
        }

        public NonNullList<String> getOreDicts() {
            return NonNullLists.emptyNonnullList();
        }

        public int getWidth() {
            return 0;
        }

        public int getHeight() {
            return 0;
        }

        public ItemStack getPlan() {
            return this.cast;
        }
    }

    public static class Consuming
    extends ThermionicCastingRecipe {
        private final NonNullList<NonNullList<ItemStack>> castStacks;
        private final NonNullList<String> oreEntry;

        public Consuming(NonNullList<ItemStack> castStacks, @Nullable String oreEntry, FluidStack liquid, ItemStack output) {
            super(liquid, output);
            this.castStacks = NonNullLists.nonnullListOf(castStacks);
            this.oreEntry = NonNullLists.nonnullListOf((Object)(oreEntry != null ? oreEntry : ""));
        }

        public Consuming(String oreEntry, FluidStack liquid, ItemStack output) {
            this((NonNullList<ItemStack>)NonNullLists.wrapNonnull((List)OreDictionary.getOres((String)oreEntry)), oreEntry, liquid, output);
        }

        public NonNullList<NonNullList<ItemStack>> getIngredients() {
            return this.castStacks;
        }

        public NonNullList<String> getOreDicts() {
            return this.oreEntry;
        }

        public int getWidth() {
            return 1;
        }

        public int getHeight() {
            return 1;
        }

        public ItemStack getPlan() {
            return ItemStack.field_190927_a;
        }
    }
}

