/*
 * Decompiled with CFR 0.152.
 */
package xyz.phanta.tconevo.item.tool;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import io.github.phantamanta44.libnine.util.math.LinAlUtils;
import io.github.phantamanta44.libnine.util.math.MathUtils;
import java.util.List;
import java.util.Optional;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketAnimation;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import slimeknights.mantle.util.RecipeMatch;
import slimeknights.tconstruct.library.events.ProjectileEvent;
import slimeknights.tconstruct.library.materials.BowMaterialStats;
import slimeknights.tconstruct.library.materials.ExtraMaterialStats;
import slimeknights.tconstruct.library.materials.HandleMaterialStats;
import slimeknights.tconstruct.library.materials.HeadMaterialStats;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.library.tinkering.Category;
import slimeknights.tconstruct.library.tinkering.PartMaterialType;
import slimeknights.tconstruct.library.tools.IToolPart;
import slimeknights.tconstruct.library.tools.ProjectileLauncherNBT;
import slimeknights.tconstruct.library.tools.TinkerToolCore;
import slimeknights.tconstruct.library.tools.ranged.IProjectile;
import slimeknights.tconstruct.library.traits.ITrait;
import slimeknights.tconstruct.library.utils.TinkerUtil;
import slimeknights.tconstruct.library.utils.ToolHelper;
import slimeknights.tconstruct.library.utils.TooltipBuilder;
import slimeknights.tconstruct.tools.TinkerTools;
import xyz.phanta.tconevo.TconEvoMod;
import xyz.phanta.tconevo.entity.EntityMagicMissile;
import xyz.phanta.tconevo.init.TconEvoItems;
import xyz.phanta.tconevo.init.TconEvoPartTypes;
import xyz.phanta.tconevo.material.stats.MagicMaterialStats;
import xyz.phanta.tconevo.network.SPacketEntitySpecialEffect;
import xyz.phanta.tconevo.util.DamageUtils;
import xyz.phanta.tconevo.util.ToolUtils;

public class ItemToolSceptre
extends TinkerToolCore
implements IProjectile {
    private static final float DURABILITY_MOD = 1.3f;
    private static final int[] REPAIR_PARTS = new int[]{1, 2};

    public ItemToolSceptre() {
        super(new PartMaterialType[]{PartMaterialType.handle((IToolPart)TinkerTools.toughToolRod), TconEvoPartTypes.magic((IToolPart)TconEvoItems.PART_ARCANE_FOCUS), PartMaterialType.head((IToolPart)TinkerTools.largePlate), PartMaterialType.extra((IToolPart)TinkerTools.toughBinding)});
        this.addCategory(new Category[]{Category.WEAPON, Category.LAUNCHER});
    }

    public String getIdentifier() {
        return "tconevo.sceptre";
    }

    public float damagePotential() {
        return 0.8f;
    }

    public double attackSpeed() {
        return 1.6;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!ToolHelper.isBroken((ItemStack)stack)) {
            if (!world.field_72995_K) {
                if (!player.field_71075_bZ.field_75098_d) {
                    ToolHelper.damageTool((ItemStack)stack, (int)8, (EntityLivingBase)player);
                }
                ProjectileLauncherNBT data = ProjectileLauncherNBT.from((ItemStack)stack);
                Vec3d look = player.func_70040_Z();
                Vec3d up = player.func_174806_f(player.field_70125_A - 90.0f, player.field_70177_z);
                int colour = ToolUtils.getToolMaterials((ItemStack)stack).get((int)1).materialTextColor;
                ItemToolSceptre.emitProjectile(world, (EntityLivingBase)player, look, data.range, stack, colour);
                ItemToolSceptre.emitProjectile(world, (EntityLivingBase)player, LinAlUtils.rotate((Vec3d)look, (Vec3d)up, (float)-0.2617994f), data.range, stack, colour);
                ItemToolSceptre.emitProjectile(world, (EntityLivingBase)player, LinAlUtils.rotate((Vec3d)look, (Vec3d)up, (float)0.2617994f), data.range, stack, colour);
                world.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_191244_bn, SoundCategory.PLAYERS, 1.5f, 0.8f + field_77697_d.nextFloat() * 0.4f);
                player.func_184811_cZ().func_185145_a((Item)this, MathUtils.clamp((int)((int)Math.round(16.0 / (double)data.drawSpeed)), (int)1, (int)100));
                if (player instanceof EntityPlayerMP) {
                    ((EntityPlayerMP)player).field_71135_a.func_147359_a((Packet)new SPacketAnimation((Entity)player, hand == EnumHand.MAIN_HAND ? 0 : 3));
                }
            }
            player.func_184609_a(hand);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        return new ActionResult(EnumActionResult.PASS, (Object)stack);
    }

    private static void emitProjectile(World world, EntityLivingBase shooter, Vec3d trajectory, float velocity, ItemStack weapon, int colour) {
        EntityMagicMissile missile = new EntityMagicMissile(world, shooter, trajectory, velocity, weapon);
        missile.setColour(colour);
        if (ProjectileEvent.OnLaunch.fireEvent((Entity)missile, (ItemStack)weapon, (EntityLivingBase)shooter)) {
            world.func_72838_d((Entity)missile);
        }
    }

    public boolean dealDamage(ItemStack stack, EntityLivingBase player, Entity entity, float damage) {
        if (DamageUtils.attackEntityWithTool(player, stack, entity, DamageUtils.getEntityDamageSource(player).func_82726_p(), damage)) {
            TconEvoMod.PROXY.playEntityEffect(entity, SPacketEntitySpecialEffect.EffectType.ENTROPY_BURST);
            return true;
        }
        return false;
    }

    public boolean dealDamageRanged(ItemStack stack, Entity projectile, EntityLivingBase player, Entity entity, float damage) {
        return DamageUtils.attackEntityWithTool(player, stack, entity, DamageUtils.getProjectileDamageSource(entity, player, projectile).func_82726_p(), damage);
    }

    public Multimap<String, AttributeModifier> getProjectileAttributeModifier(ItemStack stack) {
        HashMultimap multimap = HashMultimap.create();
        multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Weapon modifier", (double)ToolHelper.getActualAttack((ItemStack)stack), 0));
        multimap.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "Weapon modifier", Double.MAX_VALUE, 0));
        for (ITrait trait : TinkerUtil.getTraitsOrdered((ItemStack)stack)) {
            trait.getAttributeModifiers(EntityEquipmentSlot.MAINHAND, stack, (Multimap)multimap);
        }
        return multimap;
    }

    public int[] getRepairParts() {
        return REPAIR_PARTS;
    }

    public float getRepairModifierForPart(int index) {
        return index == 1 ? 1.3f : 0.97499996f;
    }

    protected int repairCustom(Material material, NonNullList<ItemStack> repairItems) {
        Optional matchOptional = material.matches(repairItems);
        return matchOptional.map(match -> {
            RecipeMatch.removeMatch((NonNullList)repairItems, (RecipeMatch.Match)match);
            int baseDurability = 0;
            MagicMaterialStats magicStats = (MagicMaterialStats)material.getStats("tconevo.magic");
            if (magicStats != null) {
                baseDurability = magicStats.durability;
            } else {
                HeadMaterialStats headStats = (HeadMaterialStats)material.getStats("head");
                if (headStats != null) {
                    baseDurability = headStats.durability;
                }
            }
            return (int)((float)baseDurability * ((float)match.amount / 144.0f));
        }).orElse(0);
    }

    public ProjectileLauncherNBT buildTagData(List<Material> materials) {
        HandleMaterialStats handle = (HandleMaterialStats)materials.get(0).getStatsOrUnknown("handle");
        MagicMaterialStats magic = (MagicMaterialStats)materials.get(1).getStatsOrUnknown("tconevo.magic");
        HeadMaterialStats setting = (HeadMaterialStats)materials.get(2).getStatsOrUnknown("head");
        ExtraMaterialStats hilt = (ExtraMaterialStats)materials.get(3).getStatsOrUnknown("extra");
        ProjectileLauncherNBT data = new ProjectileLauncherNBT();
        data.head(new HeadMaterialStats[]{setting, magic.asHead(0.0f, 1.0f)});
        data.extra(new ExtraMaterialStats[]{hilt});
        data.handle(new HandleMaterialStats[]{handle});
        data.limb(new BowMaterialStats[]{magic.asBow(0.0f)});
        data.durability = (int)((float)data.durability * 1.3f);
        return data;
    }

    public List<String> getInformation(ItemStack stack, boolean detailed) {
        TooltipBuilder info = new TooltipBuilder(stack);
        info.addDurability(!detailed);
        info.addAttack();
        info.addRange();
        if (ToolHelper.getFreeModifiers((ItemStack)stack) > 0) {
            info.addFreeModifiers();
        }
        if (detailed) {
            info.addModifierInfo();
        }
        return info.getTooltip();
    }
}

