/*
 * Decompiled with CFR 0.152.
 */
package xyz.phanta.tconevo.material;

import io.github.phantamanta44.libnine.util.helper.OreDictUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.minecraftforge.fluids.Fluid;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.library.traits.ITrait;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;
import xyz.phanta.tconevo.TconEvoMod;
import xyz.phanta.tconevo.material.MaterialBuilder;
import xyz.phanta.tconevo.material.MaterialForm;
import xyz.phanta.tconevo.material.PartType;
import xyz.phanta.tconevo.material.RegCondition;
import xyz.phanta.tconevo.util.LazyAccum;

public class MaterialDefinition {
    private static final List<String> METAL_PREFIXES = Arrays.asList("ingot", "nugget", "dust", "ore", "oreNether", "denseore", "orePoor", "oreNugget", "block", "plate", "gear");
    private static final List<MaterialDefinition> materialDefs = new ArrayList<MaterialDefinition>();
    private final Material material;
    private final MaterialForm form;
    private final String oreName;
    private final List<RegCondition> conditions;
    private final Map<PartType, LazyAccum<ITrait>> traits;

    public static void register(Material material, MaterialForm form, String oreName, List<RegCondition> conditions, Map<PartType, LazyAccum<ITrait>> traits) {
        materialDefs.add(new MaterialDefinition(material, form, oreName, conditions, traits));
    }

    public static void initMaterialProperties() {
        for (MaterialDefinition defn : materialDefs) {
            try {
                defn.initProperties();
            }
            catch (Exception e) {
                TconEvoMod.LOGGER.error("Encountered exception while initializing material {}", (Object)defn.material.identifier);
                TconEvoMod.LOGGER.error("Stack trace:", (Throwable)e);
            }
        }
    }

    public static void activate() {
        for (MaterialDefinition defn : materialDefs) {
            try {
                defn.tryActivate();
            }
            catch (Exception e) {
                TconEvoMod.LOGGER.error("Encountered exception while activating material {}", (Object)defn.material.identifier);
                TconEvoMod.LOGGER.error("Stack trace:", (Throwable)e);
            }
        }
    }

    private MaterialDefinition(Material material, MaterialForm form, String oreName, List<RegCondition> conditions, Map<PartType, LazyAccum<ITrait>> traits) {
        this.material = material;
        this.form = form;
        this.oreName = oreName;
        this.conditions = conditions;
        this.traits = traits;
    }

    private void initProperties() {
        if (this.form == MaterialForm.METAL) {
            this.material.addCommonItems(this.oreName);
        } else {
            for (MaterialForm.Entry entry : this.form.entries) {
                this.material.addItem(entry.prefix + this.oreName, 1, entry.value);
            }
        }
        for (Map.Entry entry : this.traits.entrySet()) {
            for (String typeKey : ((PartType)((Object)entry.getKey())).typeKeys) {
                for (ITrait trait : ((LazyAccum)entry.getValue()).collect()) {
                    if (this.material.hasTrait(trait.getIdentifier(), typeKey)) continue;
                    this.material.addTrait(trait, typeKey);
                }
            }
        }
    }

    private void tryActivate() {
        if (MaterialBuilder.isNotWhitelisted(this.material.identifier)) {
            for (RegCondition condition : this.conditions) {
                if (condition.isSatisfied()) continue;
                return;
            }
        }
        (this.form == MaterialForm.METAL ? METAL_PREFIXES.stream() : this.form.entries.stream().map(e -> e.prefix)).map(prefix -> prefix + this.oreName).filter(OreDictUtils::exists).findFirst().ifPresent(arg_0 -> ((Material)this.material).setRepresentativeItem(arg_0));
        Fluid fluid = this.material.getFluid();
        if (fluid != null) {
            if (this.form == MaterialForm.METAL) {
                TinkerSmeltery.registerOredictMeltingCasting((Fluid)this.material.getFluid(), (String)this.oreName);
            } else {
                for (MaterialForm.Entry entry : this.form.entries) {
                    String oreKey = entry.prefix + this.oreName;
                    TinkerRegistry.registerMelting((String)oreKey, (Fluid)fluid, (int)entry.value);
                    if (entry.castType == null) continue;
                    entry.castType.registerCasting(oreKey, fluid, entry.value);
                }
            }
            TinkerSmeltery.registerToolpartMeltingCasting((Material)this.material);
        }
        this.material.setVisible();
    }
}

