/*
 * Decompiled with CFR 0.152.
 */
package xyz.phanta.tconevo.material.stats;

import java.util.Arrays;
import java.util.List;
import net.minecraft.util.text.TextFormatting;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.library.client.CustomFontColor;
import slimeknights.tconstruct.library.materials.AbstractMaterialStats;
import slimeknights.tconstruct.library.materials.BowMaterialStats;
import slimeknights.tconstruct.library.materials.HeadMaterialStats;
import xyz.phanta.tconevo.integration.avaritia.AvaritiaHooks;

public class MagicMaterialStats
extends AbstractMaterialStats {
    public static final String LOC_BASE = "stat.tconevo.magic.";
    public static final String LOC_POTENCY_BASE = "stat.tconevo.magic.potency.";
    public static final String LOC_POTENCY_NAME = "stat.tconevo.magic.potency.name";
    public static final String LOC_POTENCY_DESC = "stat.tconevo.magic.potency.desc";
    public static final String COL_POTENCY = CustomFontColor.encodeColor((int)215, (int)100, (int)100);
    public final int durability;
    public final float potency;
    public final float range;
    public final int harvestLevel;

    public MagicMaterialStats(int durability, float potency, float range, int harvestLevel) {
        super("tconevo.magic");
        this.durability = durability;
        this.potency = potency;
        this.range = range;
        this.harvestLevel = harvestLevel;
    }

    public List<String> getLocalizedInfo() {
        return Arrays.asList(HeadMaterialStats.formatDurability((int)this.durability), MagicMaterialStats.formatNumber((String)LOC_POTENCY_NAME, (String)COL_POTENCY, (float)this.potency), BowMaterialStats.formatRange((float)this.range), HeadMaterialStats.formatHarvestLevel((int)this.harvestLevel));
    }

    public List<String> getLocalizedDesc() {
        return Arrays.asList(Util.translate((String)"stat.head.durability.desc", (Object[])new Object[0]), Util.translate((String)LOC_POTENCY_DESC, (Object[])new Object[0]), Util.translate((String)"stat.bow.range.desc", (Object[])new Object[0]), Util.translate((String)"stat.head.harvestlevel.desc", (Object[])new Object[0]));
    }

    public HeadMaterialStats asHead(float effMult, float attackMult) {
        return new HeadMaterialStats(this.durability, this.potency * effMult, this.potency * attackMult, this.harvestLevel);
    }

    public BowMaterialStats asBow(float bonusDmgMult) {
        return new BowMaterialStats(1.0f, this.range, this.potency * bonusDmgMult);
    }

    public static class Fabulous
    extends MagicMaterialStats {
        public Fabulous(int durability, float potency, float range, int harvestLevel) {
            super(durability, potency, range, harvestLevel);
        }

        @Override
        public List<String> getLocalizedInfo() {
            return Arrays.asList(HeadMaterialStats.formatDurability((int)this.durability), Util.translate((String)MagicMaterialStats.LOC_POTENCY_NAME, (Object[])new Object[0]) + ": " + AvaritiaHooks.INSTANCE.formatRainbowText(Util.df.format(this.potency)) + TextFormatting.RESET, BowMaterialStats.formatRange((float)this.range), HeadMaterialStats.formatHarvestLevel((int)this.harvestLevel));
        }
    }
}

