/*
 * Decompiled with CFR 0.152.
 */
package xyz.phanta.tconevo.trait;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import slimeknights.tconstruct.library.traits.AbstractTrait;
import xyz.phanta.tconevo.TconEvoConfig;
import xyz.phanta.tconevo.TconEvoMod;
import xyz.phanta.tconevo.util.DamageUtils;
import xyz.phanta.tconevo.util.ToolUtils;

public class TraitChainLightning
extends AbstractTrait {
    public TraitChainLightning() {
        super("tconevo.chain_lightning", 3326940);
    }

    public void afterHit(ItemStack tool, EntityLivingBase player, EntityLivingBase target, float damageDealt, boolean wasCritical, boolean wasHit) {
        if (target.field_70170_p.field_72995_K || !wasHit || player instanceof EntityPlayer && ((EntityPlayer)player).func_184825_o(0.5f) < 0.95f) {
            return;
        }
        float lightningDmg = damageDealt * (float)TconEvoConfig.general.traitChainLightningDamageMultiplier;
        if (lightningDmg <= 0.0f) {
            return;
        }
        double odds = TconEvoConfig.general.traitChainLightningProbability;
        if (odds <= 0.0 || odds < 1.0 && random.nextDouble() > odds) {
            return;
        }
        LinkedHashSet<EntityLivingBase> toStrike = new LinkedHashSet<EntityLivingBase>();
        toStrike.add(target);
        EntityLivingBase lastHit = target;
        double range = TconEvoConfig.general.traitChainLightningRange;
        for (int i = TconEvoConfig.general.traitChainLightningBounces; i > 0; --i) {
            Entity nextTarget = null;
            double minDistSq = Double.POSITIVE_INFINITY;
            for (Entity entity : lastHit.field_70170_p.func_175674_a((Entity)player, new AxisAlignedBB(lastHit.field_70165_t - range, lastHit.field_70163_u - range, lastHit.field_70161_v - range, lastHit.field_70165_t + range, lastHit.field_70163_u + range, lastHit.field_70161_v + range), null)) {
                double distSq;
                if (!(entity instanceof EntityLivingBase) || toStrike.contains(entity) || !((distSq = lastHit.func_70068_e(entity)) < minDistSq)) continue;
                nextTarget = entity;
                minDistSq = distSq;
            }
            if (nextTarget == null) break;
            lastHit = (EntityLivingBase)nextTarget;
            toStrike.add(lastHit);
        }
        DamageSource dmgSrc = DamageUtils.getEntityDamageSource(player).func_82726_p();
        ArrayList<Vec3d> hitPositions = new ArrayList<Vec3d>();
        for (EntityLivingBase hit : toStrike) {
            hitPositions.add(new Vec3d(hit.field_70165_t, hit.field_70163_u + (double)hit.field_70131_O / 2.0, hit.field_70161_v));
            hit.field_70172_ad = 0;
            DamageUtils.attackEntityWithTool(player, tool, (Entity)hit, dmgSrc, lightningDmg);
        }
        TconEvoMod.PROXY.playLightningEffect((Entity)target, hitPositions);
    }

    public List<String> getExtraInfo(ItemStack tool, NBTTagCompound modifierTag) {
        return ToolUtils.formatExtraInfoPercent(this.identifier, (float)TconEvoConfig.general.traitChainLightningProbability);
    }
}

