/*
 * Decompiled with CFR 0.152.
 */
package xyz.phanta.tconevo.trait;

import io.github.phantamanta44.libnine.capability.provider.CapabilityBroker;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import xyz.phanta.tconevo.TconEvoConfig;
import xyz.phanta.tconevo.TconEvoMod;
import xyz.phanta.tconevo.client.event.ItemStackBarEvent;
import xyz.phanta.tconevo.trait.ModifierFluxed;
import xyz.phanta.tconevo.trait.base.EnergeticModifier;
import xyz.phanta.tconevo.trait.base.StackableTrait;
import xyz.phanta.tconevo.util.ItemEnergyStore;
import xyz.phanta.tconevo.util.ToolUtils;

public class TraitEnergized
extends StackableTrait
implements EnergeticModifier {
    public static final int COLOUR = 12976385;
    private static final String TAG_ENERGY = "EnergizedEnergy";

    public TraitEnergized(int level) {
        super("tconevo.energized", 12976385, 2, level);
        if (level == 1) {
            TconEvoMod.PROXY.getToolCapHandler().addModifierCap("tconevo.energized", s -> new CapabilityBroker().with(CapabilityEnergy.ENERGY, (Object)new EnergizedEnergyStore((ItemStack)s)));
        }
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public int onToolDamage(ItemStack tool, int damage, int newDamage, EntityLivingBase entity) {
        if (!TraitEnergized.isCanonical(this, tool)) {
            return newDamage;
        }
        return ModifierFluxed.doDamageReduction(tool, newDamage, TconEvoConfig.general.traitEnergizedEnergyCostTools);
    }

    public int getPriority() {
        return 25;
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onItemStackBars(ItemStackBarEvent event) {
        if (this.isToolWithTrait(event.stack)) {
            event.addForgeEnergyBar("forge_energy", 12976385, 12976385);
        }
    }

    public static class EnergizedEnergyStore
    extends ItemEnergyStore {
        public EnergizedEnergyStore(ItemStack stack) {
            super(stack);
        }

        @Override
        public String getNbtKeyEnergy() {
            return TraitEnergized.TAG_ENERGY;
        }

        @Override
        public double getEnergyTransferDivider() {
            return TconEvoConfig.general.traitEnergizedEnergyTransferDivider;
        }

        public int getMaxEnergyStored() {
            return ToolUtils.getTraitLevel(this.stack, "tconevo.energized") * TconEvoConfig.general.traitEnergizedEnergyCapacityTools;
        }
    }
}

