/*
 * Decompiled with CFR 0.152.
 */
package xyz.phanta.tconevo.trait.avaritia;

import io.github.phantamanta44.libnine.util.world.WorldUtils;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import xyz.phanta.tconevo.TconEvoConfig;
import xyz.phanta.tconevo.integration.avaritia.AvaritiaHooks;
import xyz.phanta.tconevo.trait.base.IncrementalModifier;
import xyz.phanta.tconevo.trait.base.StackableTrait;
import xyz.phanta.tconevo.util.ToolUtils;

public class TraitCondensing
extends StackableTrait {
    public TraitCondensing() {
        super("tconevo.condensing", 0x3B3B3B, 10, 1);
    }

    @Override
    public IncrementalModifier.LevelCombiner getLevelCombiner() {
        return IncrementalModifier.LevelCombiner.SUM;
    }

    private static double getNeutronDropProbability(int level) {
        return (double)level * TconEvoConfig.moduleAvaritia.condensingDropProbability;
    }

    public void afterBlockBreak(ItemStack tool, World world, IBlockState state, BlockPos pos, EntityLivingBase player, boolean wasEffective) {
        if (wasEffective && !world.field_72995_K && TraitCondensing.isCanonical(this, tool)) {
            TraitCondensing.tryDropNeutrons(world, (double)pos.func_177958_n() + 0.5, pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, tool);
        }
    }

    public void afterHit(ItemStack tool, EntityLivingBase player, EntityLivingBase target, float damageDealt, boolean wasCritical, boolean wasHit) {
        if (!target.func_70089_S() && !target.field_70170_p.field_72995_K && TraitCondensing.isCanonical(this, tool)) {
            TraitCondensing.tryDropNeutrons(target.func_130014_f_(), target.field_70165_t, target.field_70163_u, target.field_70161_v, tool);
        }
    }

    private static void tryDropNeutrons(World world, double x, double y, double z, ItemStack tool) {
        double odds = TraitCondensing.getNeutronDropProbability(ToolUtils.getTraitLevel(tool, "tconevo.condensing"));
        if (odds > 0.0 && (odds >= 1.0 || random.nextDouble() <= odds)) {
            AvaritiaHooks.INSTANCE.getItemNeutronPile().ifPresent(s -> WorldUtils.dropItem((World)world, (Vec3d)new Vec3d(x, y, z), (ItemStack)s));
        }
    }

    public List<String> getExtraInfo(ItemStack tool, NBTTagCompound modifierTag) {
        return ToolUtils.formatExtraInfoPercent("tconevo.condensing", (float)TraitCondensing.getNeutronDropProbability(ToolUtils.getTraitLevel(modifierTag)));
    }
}

