/*
 * Decompiled with CFR 0.152.
 */
package xyz.phanta.tconevo.trait.base;

import io.github.phantamanta44.libnine.util.math.MathUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.library.modifiers.IModifier;
import slimeknights.tconstruct.library.modifiers.ModifierAspect;
import slimeknights.tconstruct.library.modifiers.ModifierNBT;
import slimeknights.tconstruct.library.traits.AbstractTrait;
import slimeknights.tconstruct.library.utils.TagUtil;
import slimeknights.tconstruct.library.utils.TinkerUtil;
import xyz.phanta.tconevo.trait.base.IncrementalModifier;
import xyz.phanta.tconevo.util.ToolUtils;

public abstract class StackableTrait
extends AbstractTrait
implements IncrementalModifier {
    private static final String TAG_CANONICAL_LEVEL = "CanonicalTraitLevel";
    private static final Map<String, Pattern> traitIdPatterns = new HashMap<String, Pattern>();
    protected final String baseIdentifier;
    protected final int levelMax;
    protected final int level;

    private static Pattern getTraitIdPattern(String baseId) {
        return traitIdPatterns.computeIfAbsent(baseId, id -> Pattern.compile(Pattern.quote(id) + "\\d+"));
    }

    public StackableTrait(String identifier, int color, int levelMax, int level) {
        super(identifier + level, color);
        this.baseIdentifier = identifier;
        this.levelMax = levelMax;
        this.level = level;
        if (level == 1) {
            TinkerRegistry.registerModifierAlias((IModifier)this, (String)this.baseIdentifier);
        }
        this.aspects.clear();
        this.addAspects(new ModifierAspect[]{new ModifierAspect.LevelAspect((IModifier)this, levelMax), new ModifierAspect.DataAspect((IModifier)this, color)});
    }

    @Override
    public String getBaseIdentifier() {
        return this.baseIdentifier;
    }

    @Override
    public int getLevelIncrement() {
        return this.level;
    }

    @Override
    public int getLevelMaximum() {
        return this.levelMax;
    }

    public boolean isToolWithStackableTrait(ItemStack stack) {
        return ToolUtils.hasModifier(stack, this.getBaseIdentifier());
    }

    public void updateNBTforTrait(NBTTagCompound modifierTag, int newColor) {
        super.updateNBTforTrait(modifierTag, newColor);
        ModifierNBT data = ModifierNBT.readTag((NBTTagCompound)modifierTag);
        data.level = 0;
        data.write(modifierTag);
    }

    public void applyEffect(NBTTagCompound rootCompound, NBTTagCompound modifierTag) {
        super.applyEffect(rootCompound, modifierTag);
        StackableTrait.applyStacks(this, rootCompound, this.color);
    }

    public static void applyStacks(IncrementalModifier mod, NBTTagCompound rootTag, int colour) {
        ModifierNBT modData;
        NBTTagList modDataTags = TagUtil.getModifiersTagList((NBTTagCompound)rootTag);
        NBTTagCompound newDataTag = new NBTTagCompound();
        int modDataNdx = TinkerUtil.getIndexInCompoundList((NBTTagList)modDataTags, (String)mod.getBaseIdentifier());
        if (modDataNdx > -1) {
            NBTTagCompound modDataTag = modDataTags.func_150305_b(modDataNdx);
            modDataTags.func_150304_a(modDataNdx, (NBTBase)newDataTag);
            modData = ModifierNBT.readTag((NBTTagCompound)modDataTag);
        } else {
            modDataTags.func_74742_a((NBTBase)newDataTag);
            modData = new ModifierNBT();
            modData.identifier = mod.getBaseIdentifier();
            modData.color = colour;
        }
        int newLevel = MathUtils.clamp((int)mod.getLevelCombiner().apply(modData.level, mod.getLevelIncrement()), (int)1, (int)mod.getLevelMaximum());
        if (newLevel != modData.level) {
            mod.applyEffectIncremental(rootTag, modData.level, newLevel);
            modData.level = newLevel;
        }
        newDataTag.func_74768_a(TAG_CANONICAL_LEVEL, mod.getLevelIncrement());
        modData.write(newDataTag);
        TagUtil.setModifiersTagList((NBTTagCompound)rootTag, (NBTTagList)modDataTags);
    }

    public static boolean isCanonical(IncrementalModifier mod, ItemStack tool) {
        NBTTagCompound modTag = TinkerUtil.getModifierTag((ItemStack)tool, (String)mod.getBaseIdentifier());
        if (modTag == null) {
            return false;
        }
        if (modTag.func_150297_b(TAG_CANONICAL_LEVEL, 3)) {
            return modTag.func_74762_e(TAG_CANONICAL_LEVEL) == mod.getLevelIncrement();
        }
        NBTTagList traitList = TagUtil.getTraitsTagList((ItemStack)tool);
        Pattern idPattern = StackableTrait.getTraitIdPattern(mod.getBaseIdentifier());
        for (int i = 0; i < traitList.func_74745_c(); ++i) {
            String traitId = traitList.func_150307_f(i);
            if (!idPattern.matcher(traitId).matches()) continue;
            return mod.getIdentifier().equals(traitId);
        }
        return false;
    }

    public String getModifierIdentifier() {
        return this.baseIdentifier;
    }

    public String getLocalizedName() {
        String name = Util.translate((String)"modifier.%s.name", (Object[])new Object[]{this.baseIdentifier});
        return this.level > 1 ? name + " " + TinkerUtil.getRomanNumeral((int)this.level) : name;
    }

    public String getLocalizedDesc() {
        return Util.translate((String)"modifier.%s.desc", (Object[])new Object[]{this.baseIdentifier});
    }

    public String getTooltip(NBTTagCompound modifierTag, boolean detailed) {
        return this.getLeveledTooltip(modifierTag, detailed);
    }
}

