/*
 * Decompiled with CFR 0.152.
 */
package xyz.phanta.tconevo.trait.bloodmagic;

import com.google.common.collect.Multimap;
import io.github.phantamanta44.libnine.util.helper.ItemUtils;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraftforge.event.entity.player.PlayerEvent;
import slimeknights.tconstruct.library.traits.AbstractTrait;
import xyz.phanta.tconevo.TconEvoConfig;
import xyz.phanta.tconevo.integration.bloodmagic.BloodMagicHooks;
import xyz.phanta.tconevo.integration.bloodmagic.DemonWillType;

public class TraitSentient
extends AbstractTrait {
    public static final int COLOUR = 8314595;
    private static final String TAG_WILL_TYPE = "SentientWillType";
    private static final String TAG_WILL_TIER = "SentientWillTier";
    private static final UUID ATTR_ATK_DMG = UUID.fromString("1b66a53d-7803-4d22-9fb6-cd97615c95c9");
    private static final UUID ATTR_ATK_SPD = UUID.fromString("fdd93b81-dbf6-4865-98d3-6e68faba19d3");
    private static final UUID ATTR_MOVE_SPD = UUID.fromString("1fbbf426-2c20-4ccb-973f-6e1188421e73");

    public TraitSentient() {
        super("tconevo.sentient", 8314595);
    }

    public int onToolDamage(ItemStack tool, int damage, int newDamage, EntityLivingBase entity) {
        if (entity instanceof EntityPlayer) {
            WillPower willPower = TraitSentient.getWillPower(tool);
            double cost = willPower.getWillCost() * (double)newDamage;
            if (cost > 0.0) {
                BloodMagicHooks.INSTANCE.extractDemonWill((EntityPlayer)entity, willPower.getWillType(), cost);
            }
            TraitSentient.updateWillPowerTool(tool, (EntityPlayer)entity);
        } else {
            TraitSentient.updateWillPowerTool(tool, null);
        }
        return newDamage;
    }

    public void miningSpeed(ItemStack tool, PlayerEvent.BreakSpeed event) {
        event.setNewSpeed(event.getNewSpeed() + event.getOriginalSpeed() * TraitSentient.getWillPower(tool).getDigSpeedModifier());
    }

    public void onHit(ItemStack tool, EntityLivingBase player, EntityLivingBase target, float damage, boolean isCritical) {
        TraitSentient.updateWillPowerTool(tool, player instanceof EntityPlayer ? (EntityPlayer)player : null);
    }

    public void afterHit(ItemStack tool, EntityLivingBase player, EntityLivingBase target, float damageDealt, boolean wasCritical, boolean wasHit) {
        if (!target.field_70170_p.field_72995_K && wasHit) {
            TraitSentient.getWillPower(tool).afterHit(player, target);
        }
    }

    public void getAttributeModifiers(EntityEquipmentSlot slot, ItemStack stack, Multimap<String, AttributeModifier> attributeMap) {
        if (slot == EntityEquipmentSlot.MAINHAND) {
            WillPower willPower = TraitSentient.getWillPower(stack);
            attributeMap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(ATTR_ATK_DMG, "Sentient Attack Damage", willPower.getAttackDamageModifier(), 0));
            attributeMap.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(ATTR_ATK_SPD, "Sentient Attack Speed", willPower.getAttackSpeedModifier(), 1));
            attributeMap.put((Object)SharedMonsterAttributes.field_111263_d.func_111108_a(), (Object)new AttributeModifier(ATTR_MOVE_SPD, "Sentient Move Speed", willPower.getMoveSpeedModifier(), 1));
        }
    }

    public int getPriority() {
        return 110;
    }

    private static WillPower updateWillPowerTool(ItemStack stack, @Nullable EntityPlayer wielder) {
        return TraitSentient.updateWillPower(stack, wielder, TconEvoConfig.moduleBloodMagic.sentientTierThresholds);
    }

    public static WillPower updateWillPower(ItemStack stack, @Nullable EntityPlayer wielder, double[] thresholds) {
        WillPower willPower;
        DemonWillType type;
        double amount;
        if (wielder != null && (amount = BloodMagicHooks.INSTANCE.getTotalDemonWill(wielder, type = BloodMagicHooks.INSTANCE.getLargestWillType(wielder))) > 0.0) {
            int tier;
            for (tier = 0; tier < thresholds.length && amount >= thresholds[tier]; ++tier) {
            }
            willPower = WillPower.get(type, tier);
        } else {
            willPower = WillPower.zero();
        }
        willPower.writeToNbt(ItemUtils.getOrCreateTag((ItemStack)stack));
        return willPower;
    }

    public static WillPower getWillPower(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return WillPower.zero();
        }
        NBTTagCompound tag = Objects.requireNonNull(stack.func_77978_p());
        int typeOrd = tag.func_74762_e(TAG_WILL_TYPE);
        if (typeOrd < 0 || typeOrd >= DemonWillType.VALUES.length) {
            return WillPower.zero();
        }
        return WillPower.get(DemonWillType.VALUES[typeOrd], Math.max(tag.func_74762_e(TAG_WILL_TIER), 0));
    }

    public static abstract class WillPower {
        protected final int tier;

        public static WillPower zero() {
            return Raw.ZERO;
        }

        public static WillPower get(DemonWillType type, int tier) {
            switch (type) {
                case RAW: {
                    return new Raw(tier);
                }
                case CORROSIVE: {
                    return new Corrosive(tier);
                }
                case DESTRUCTIVE: {
                    return new Destructive(tier);
                }
                case VENGEFUL: {
                    return new Vengeful(tier);
                }
                case STEADFAST: {
                    return new Steadfast(tier);
                }
            }
            throw new IllegalArgumentException("Bad demon will type: " + (Object)((Object)type));
        }

        protected WillPower(int tier) {
            this.tier = tier;
        }

        public abstract DemonWillType getWillType();

        public double getWillCost() {
            return TconEvoConfig.moduleBloodMagic.sentientWillCostBase + (double)this.tier * TconEvoConfig.moduleBloodMagic.sentientWillCostPerLevel;
        }

        public double getStaticDropRate() {
            return TconEvoConfig.moduleBloodMagic.willfulStaticDropBase + (double)this.tier * TconEvoConfig.moduleBloodMagic.willfulStaticDropPerLevel;
        }

        public double getBonusDropRate() {
            return TconEvoConfig.moduleBloodMagic.willfulBonusDropBase + (double)this.tier * TconEvoConfig.moduleBloodMagic.willfulBonusDropPerLevel;
        }

        public float getDigSpeedModifier() {
            return (float)this.tier * (float)TconEvoConfig.moduleBloodMagic.sentientDigSpeedPerLevel;
        }

        public abstract double getAttackDamageModifier();

        public double getAttackSpeedModifier() {
            return 0.0;
        }

        public double getMoveSpeedModifier() {
            return 0.0;
        }

        public void afterHit(EntityLivingBase attacker, EntityLivingBase target) {
        }

        public double getArmourWillCost() {
            return TconEvoConfig.moduleBloodMagic.sentientArmourWillCostBase + (double)this.tier * TconEvoConfig.moduleBloodMagic.sentientArmourWillCostPerLevel;
        }

        public abstract double getArmourProtectionModifier();

        public double getArmourKnockbackModifier() {
            return 0.0;
        }

        public double getArmourMoveSpeedModifier() {
            return 0.0;
        }

        public double getArmourAttackDamageModifier() {
            return 0.0;
        }

        public double getArmourAttackSpeedModifier() {
            return 0.0;
        }

        public void writeToNbt(NBTTagCompound tag) {
            tag.func_74768_a(TraitSentient.TAG_WILL_TYPE, this.getWillType().ordinal());
            tag.func_74768_a(TraitSentient.TAG_WILL_TIER, this.tier);
        }

        private static class Steadfast
        extends WillPower {
            Steadfast(int tier) {
                super(tier);
            }

            @Override
            public DemonWillType getWillType() {
                return DemonWillType.STEADFAST;
            }

            @Override
            public double getAttackDamageModifier() {
                return TconEvoConfig.moduleBloodMagic.sentientSteadfastDamageBase + (double)this.tier * TconEvoConfig.moduleBloodMagic.sentientSteadfastDamagePerLevel;
            }

            @Override
            public void afterHit(EntityLivingBase attacker, EntityLivingBase target) {
                if (!target.func_70089_S()) {
                    float absorption = attacker.func_110139_bj();
                    attacker.func_70690_d(new PotionEffect(MobEffects.field_76444_x, TconEvoConfig.moduleBloodMagic.sentientSteadfastAbsorptionDurationBase + this.tier * TconEvoConfig.moduleBloodMagic.sentientSteadfastAbsorptionDurationPerLevel, 127));
                    attacker.func_110149_m(Math.min(10.0f, absorption + target.func_110138_aP() * (float)TconEvoConfig.moduleBloodMagic.sentientSteadfastAbsorptionHealthRatio));
                }
            }

            @Override
            public double getArmourProtectionModifier() {
                return TconEvoConfig.moduleBloodMagic.sentientSteadfastArmourProtectionBase + (double)this.tier * TconEvoConfig.moduleBloodMagic.sentientSteadfastArmourProtectionPerLevel;
            }

            @Override
            public double getArmourKnockbackModifier() {
                return TconEvoConfig.moduleBloodMagic.sentientSteadfastArmourKnockbackResistBase + (double)this.tier * TconEvoConfig.moduleBloodMagic.sentientSteadfastArmourKnockbackResistPerLevel;
            }
        }

        private static class Vengeful
        extends WillPower {
            Vengeful(int tier) {
                super(tier);
            }

            @Override
            public DemonWillType getWillType() {
                return DemonWillType.VENGEFUL;
            }

            @Override
            public double getAttackDamageModifier() {
                return TconEvoConfig.moduleBloodMagic.sentientVengefulDamageBase + (double)this.tier * TconEvoConfig.moduleBloodMagic.sentientVengefulDamagePerLevel;
            }

            @Override
            public double getAttackSpeedModifier() {
                return TconEvoConfig.moduleBloodMagic.sentientVengefulAttackSpeedBase + (double)this.tier * TconEvoConfig.moduleBloodMagic.sentientVengefulAttackSpeedPerLevel;
            }

            @Override
            public double getMoveSpeedModifier() {
                return TconEvoConfig.moduleBloodMagic.sentientVengefulMoveSpeedBase + (double)this.tier * TconEvoConfig.moduleBloodMagic.sentientVengefulMoveSpeedPerLevel;
            }

            @Override
            public double getArmourProtectionModifier() {
                return TconEvoConfig.moduleBloodMagic.sentientVengefulArmourProtectionBase + (double)this.tier * TconEvoConfig.moduleBloodMagic.sentientVengefulArmourProtectionPerLevel;
            }

            @Override
            public double getArmourMoveSpeedModifier() {
                return TconEvoConfig.moduleBloodMagic.sentientVengefulArmourMoveSpeedBase + (double)this.tier * TconEvoConfig.moduleBloodMagic.sentientVengefulArmourMoveSpeedPerLevel;
            }
        }

        private static class Destructive
        extends WillPower {
            Destructive(int tier) {
                super(tier);
            }

            @Override
            public DemonWillType getWillType() {
                return DemonWillType.DESTRUCTIVE;
            }

            @Override
            public double getAttackDamageModifier() {
                return TconEvoConfig.moduleBloodMagic.sentientDestructiveDamageBase + (double)this.tier * TconEvoConfig.moduleBloodMagic.sentientDestructiveDamagePerLevel;
            }

            @Override
            public double getAttackSpeedModifier() {
                return -TconEvoConfig.moduleBloodMagic.sentientDestructiveAttackSpeedBase - (double)this.tier * TconEvoConfig.moduleBloodMagic.sentientDestructiveAttackSpeedPerLevel;
            }

            @Override
            public double getArmourProtectionModifier() {
                return TconEvoConfig.moduleBloodMagic.sentientDestructiveArmourProtectionBase + (double)this.tier * TconEvoConfig.moduleBloodMagic.sentientDestructiveArmourProtectionPerLevel;
            }

            @Override
            public double getArmourAttackDamageModifier() {
                return TconEvoConfig.moduleBloodMagic.sentientDestructiveArmourAttackDamageBase + (double)this.tier * TconEvoConfig.moduleBloodMagic.sentientDestructiveArmourAttackDamagePerLevel;
            }

            @Override
            public double getArmourAttackSpeedModifier() {
                return -TconEvoConfig.moduleBloodMagic.sentientDestructiveArmourAttackSpeedBase - (double)this.tier * TconEvoConfig.moduleBloodMagic.sentientDestructiveArmourAttackSpeedPerLevel;
            }
        }

        private static class Corrosive
        extends WillPower {
            Corrosive(int tier) {
                super(tier);
            }

            @Override
            public DemonWillType getWillType() {
                return DemonWillType.CORROSIVE;
            }

            @Override
            public double getAttackDamageModifier() {
                return TconEvoConfig.moduleBloodMagic.sentientCorrosiveDamageBase + (double)this.tier * TconEvoConfig.moduleBloodMagic.sentientCorrosiveDamagePerLevel;
            }

            @Override
            public void afterHit(EntityLivingBase attacker, EntityLivingBase target) {
                target.func_70690_d(new PotionEffect(MobEffects.field_82731_v, TconEvoConfig.moduleBloodMagic.sentientCorrosivePoisonDurationBase + this.tier * TconEvoConfig.moduleBloodMagic.sentientCorrosivePoisonDurationPerLevel, 1));
            }

            @Override
            public double getArmourProtectionModifier() {
                return TconEvoConfig.moduleBloodMagic.sentientCorrosiveArmourProtectionBase + (double)this.tier * TconEvoConfig.moduleBloodMagic.sentientCorrosiveArmourProtectionPerLevel;
            }
        }

        private static class Raw
        extends WillPower {
            static final WillPower ZERO = new Raw(0);

            public Raw(int tier) {
                super(tier);
            }

            @Override
            public DemonWillType getWillType() {
                return DemonWillType.RAW;
            }

            @Override
            public double getAttackDamageModifier() {
                return (double)this.tier * TconEvoConfig.moduleBloodMagic.sentientRawDamagePerLevel;
            }

            @Override
            public double getArmourProtectionModifier() {
                return (double)this.tier * TconEvoConfig.moduleBloodMagic.sentientRawArmourProtectionPerLevel;
            }
        }
    }
}

