/*
 * Decompiled with CFR 0.152.
 */
package xyz.phanta.tconevo.trait.draconicevolution;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import slimeknights.tconstruct.library.events.TinkerToolEvent;
import slimeknights.tconstruct.library.tinkering.Category;
import slimeknights.tconstruct.library.tools.ToolCore;
import slimeknights.tconstruct.library.utils.ToolHelper;
import slimeknights.tconstruct.tools.tools.Scythe;
import xyz.phanta.tconevo.TconEvoMod;
import xyz.phanta.tconevo.trait.draconicevolution.ModifierDraconic;

public class ModifierDraconicAttackAoe
extends ModifierDraconic {
    private final Set<UUID> alreadyAttacked = new HashSet<UUID>();

    public ModifierDraconicAttackAoe() {
        super("tconevo.draconic_attack_aoe", Category.WEAPON);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onAttackAoe(TinkerToolEvent.ExtraBlockBreak event) {
        if (TconEvoMod.PROXY.getPlayerStateHandler().isPlayerAttacking(event.player)) {
            int aoe = this.getDraconicTier(event.itemStack);
            if (aoe > 0) {
                aoe = ModifierDraconicAttackAoe.getAttackAoe(aoe);
                event.width += aoe;
                event.height += aoe;
                event.depth += aoe;
            }
            this.alreadyAttacked.add(event.player.func_110124_au());
        }
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            this.alreadyAttacked.clear();
        }
    }

    public void afterHit(ItemStack tool, EntityLivingBase playerEntity, EntityLivingBase target, float damageDealt, boolean wasCritical, boolean wasHit) {
        if (target.field_70170_p.field_72995_K || !wasHit || !(playerEntity instanceof EntityPlayer) || !(tool.func_77973_b() instanceof ToolCore)) {
            return;
        }
        ToolCore toolItem = (ToolCore)tool.func_77973_b();
        if (toolItem instanceof Scythe) {
            return;
        }
        EntityPlayer player = (EntityPlayer)playerEntity;
        if (this.alreadyAttacked.contains(player.func_110124_au()) || player.func_184825_o(0.5f) < 0.95f) {
            return;
        }
        int aoe = this.getDraconicTier(tool);
        if (aoe <= 0) {
            return;
        }
        this.alreadyAttacked.add(player.func_110124_au());
        aoe = ModifierDraconicAttackAoe.getAttackAoe(aoe);
        for (Entity hit : player.field_70170_p.func_175674_a((Entity)target, target.func_174813_aQ().func_72314_b((double)aoe, 0.25, (double)aoe), null)) {
            if (!(hit instanceof EntityLivingBase) || hit == player || player.func_184191_r(hit)) continue;
            ((EntityLivingBase)hit).func_70653_a((Entity)player, 0.4f, (double)MathHelper.func_76126_a((float)(player.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(player.field_70177_z * ((float)Math.PI / 180)))));
            ToolHelper.attackEntity((ItemStack)tool, (ToolCore)toolItem, (EntityLivingBase)player, (Entity)hit, null, (boolean)false);
        }
        double reachDist = player.func_110148_a(EntityPlayer.REACH_DISTANCE).func_111126_e() + 1.0;
        if (player.func_70068_e((Entity)target) < reachDist * reachDist) {
            player.field_70170_p.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187730_dW, player.func_184176_by(), 1.0f, 1.0f);
            player.func_184810_cG();
        }
    }

    private static int getAttackAoe(int tier) {
        switch (tier) {
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 5;
            }
            case 4: {
                return 10;
            }
        }
        return 0;
    }
}

