/*
 * Decompiled with CFR 0.152.
 */
package xyz.phanta.tconevo.trait.draconicevolution;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import slimeknights.tconstruct.library.modifiers.IModifier;
import slimeknights.tconstruct.library.modifiers.ModifierAspect;
import slimeknights.tconstruct.library.modifiers.ModifierTrait;
import xyz.phanta.tconevo.TconEvoConfig;
import xyz.phanta.tconevo.TconEvoMod;
import xyz.phanta.tconevo.integration.draconicevolution.DraconicHooks;
import xyz.phanta.tconevo.network.SPacketEntitySpecialEffect;
import xyz.phanta.tconevo.util.DamageUtils;
import xyz.phanta.tconevo.util.ToolUtils;

public class ModifierPrimordial
extends ModifierTrait {
    public ModifierPrimordial() {
        super("tconevo.primordial", 4411999, 5, 0);
        if (TconEvoConfig.moduleDraconicEvolution.primordialOnlyUsesOneModifier) {
            this.aspects.remove(this.aspects.lastIndexOf(ModifierAspect.freeModifier));
            this.addAspects(new ModifierAspect[]{new ModifierAspect.FreeFirstModifierAspect((IModifier)this, 1)});
        }
    }

    private float getDamageConversion(int level) {
        return (float)level * (float)TconEvoConfig.moduleDraconicEvolution.primordialConversionPerLevel;
    }

    public float damage(ItemStack tool, EntityLivingBase player, EntityLivingBase target, float damage, float newDamage, boolean isCritical) {
        float chaosDmg;
        if (!player.field_70170_p.field_72995_K && (chaosDmg = damage * this.getDamageConversion(ToolUtils.getTraitLevel(tool, this.identifier))) > 0.0f) {
            newDamage = Math.max(newDamage - chaosDmg, 0.0f);
            if (DamageUtils.attackEntityWithTool(player, tool, (Entity)target, DraconicHooks.INSTANCE.getChaosDamage(player), chaosDmg)) {
                target.field_70172_ad = 0;
                TconEvoMod.PROXY.playEntityEffect((Entity)target, SPacketEntitySpecialEffect.EffectType.CHAOS_BURST);
            }
        }
        return newDamage;
    }

    public int getPriority() {
        return 200;
    }

    public List<String> getExtraInfo(ItemStack tool, NBTTagCompound modifierTag) {
        return ToolUtils.formatExtraInfoPercent(this.identifier, this.getDamageConversion(ToolUtils.getTraitLevel(modifierTag)));
    }
}

