/*
 * Decompiled with CFR 0.152.
 */
package xyz.phanta.tconevo.trait.ic2;

import io.github.phantamanta44.libnine.capability.provider.CapabilityBroker;
import io.github.phantamanta44.libnine.util.helper.ItemUtils;
import io.github.phantamanta44.libnine.util.helper.OptUtils;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.traits.AbstractTrait;
import xyz.phanta.tconevo.TconEvoConfig;
import xyz.phanta.tconevo.TconEvoMod;
import xyz.phanta.tconevo.capability.EuStore;
import xyz.phanta.tconevo.client.event.ItemStackBarEvent;
import xyz.phanta.tconevo.init.TconEvoCaps;
import xyz.phanta.tconevo.integration.ic2.Ic2Hooks;
import xyz.phanta.tconevo.trait.base.EnergeticModifier;

public class TraitElectric
extends AbstractTrait
implements EnergeticModifier {
    public static final int COLOUR = 655558;
    private static final String TAG_ENERGY = "ElectricEnergy";

    public TraitElectric() {
        super("tconevo.electric", 655558);
        TconEvoMod.PROXY.getToolCapHandler().addModifierCap((Modifier)this, s -> new CapabilityBroker().with(TconEvoCaps.EU_STORE, (Object)new ElectricToolBuffer((ItemStack)s)));
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public EnergeticModifier.EnergyType getEnergyType() {
        return EnergeticModifier.EnergyType.EU;
    }

    public int onToolDamage(ItemStack tool, int damage, int newDamage, EntityLivingBase entity) {
        return TraitElectric.doDamageReduction(tool, entity, newDamage, TconEvoConfig.moduleIndustrialCraft.electricToolEnergyCost);
    }

    public static int doDamageReduction(ItemStack tool, EntityLivingBase user, int damage, double unitCost) {
        if (damage > 0) {
            return OptUtils.capability((ICapabilityProvider)tool, TconEvoCaps.EU_STORE).map(e -> e.consumeEu((double)damage * unitCost, user, true) ? 0 : damage).orElse(damage);
        }
        return damage;
    }

    public int getPriority() {
        return 25;
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onItemStackBars(ItemStackBarEvent event) {
        if (this.isToolWithTrait(event.stack)) {
            event.addEuBar();
        }
    }

    public static class ElectricToolBuffer
    implements EuStore {
        private final ItemStack stack;

        public ElectricToolBuffer(ItemStack stack) {
            this.stack = stack;
        }

        @Override
        public double injectEu(double amount, boolean ignoreTfrRate, boolean commit) {
            double rateLimit;
            double stored = this.getEuStored();
            double capacity = this.getEuStoredMax();
            double toTransfer = Math.min(amount, capacity - stored);
            if (!ignoreTfrRate && (rateLimit = TconEvoConfig.moduleIndustrialCraft.electricPowerTransferDivider) > 0.0) {
                toTransfer = Math.min(toTransfer, capacity / rateLimit);
            }
            if (toTransfer > 0.0 && commit) {
                this.setEuStored(stored + toTransfer);
            }
            return toTransfer;
        }

        @Override
        public double extractEu(double amount, boolean ignoreTfrRate, boolean commit) {
            double stored = this.getEuStored();
            double toTransfer = Math.min(amount, stored);
            if (toTransfer > 0.0 && commit) {
                this.setEuStored(stored - toTransfer);
            }
            return toTransfer;
        }

        @Override
        public boolean consumeEu(double amount, EntityLivingBase user, boolean commit) {
            return Ic2Hooks.INSTANCE.consumeEu(this.stack, amount, user, commit);
        }

        @Override
        public double getEuStored() {
            return OptUtils.stackTag((ItemStack)this.stack).map(t -> t.func_74769_h(TraitElectric.TAG_ENERGY)).orElse(0.0);
        }

        private void setEuStored(double amount) {
            ItemUtils.getOrCreateTag((ItemStack)this.stack).func_74780_a(TraitElectric.TAG_ENERGY, amount);
        }

        @Override
        public double getEuStoredMax() {
            return TconEvoConfig.moduleIndustrialCraft.electricToolEnergyBuffer;
        }

        @Override
        public int getEuTier() {
            return TconEvoConfig.moduleIndustrialCraft.electricPowerTier;
        }

        @Override
        public boolean canExtractEu() {
            return false;
        }
    }
}

