/*
 * Decompiled with CFR 0.152.
 */
package xyz.phanta.tconevo.util;

import io.github.phantamanta44.libnine.util.helper.ItemUtils;
import io.github.phantamanta44.libnine.util.helper.OptUtils;
import net.minecraft.item.ItemStack;
import xyz.phanta.tconevo.capability.RatedEnergyStorage;

public abstract class ItemEnergyStore
implements RatedEnergyStorage {
    protected final ItemStack stack;

    public ItemEnergyStore(ItemStack stack) {
        this.stack = stack;
    }

    public abstract String getNbtKeyEnergy();

    public abstract double getEnergyTransferDivider();

    @Override
    public int receiveEnergy(int maxReceive, boolean simulate, boolean ignoreTfrRate) {
        double rateLimit;
        int stored = this.getEnergyStored();
        int capacity = this.getMaxEnergyStored();
        int toTransfer = Math.min(maxReceive, capacity - stored);
        if (!ignoreTfrRate && (rateLimit = this.getEnergyTransferDivider()) > 0.0) {
            toTransfer = Math.min(toTransfer, (int)Math.ceil((double)capacity / rateLimit));
        }
        if (toTransfer > 0 && !simulate) {
            this.setEnergyStored(stored + toTransfer);
        }
        return toTransfer;
    }

    @Override
    public int extractEnergy(int maxExtract, boolean simulate, boolean ignoreTfrRate) {
        int stored = this.getEnergyStored();
        int toTransfer = Math.min(maxExtract, stored);
        if (toTransfer > 0 && !simulate) {
            this.setEnergyStored(stored - toTransfer);
        }
        return toTransfer;
    }

    public int getEnergyStored() {
        return OptUtils.stackTag((ItemStack)this.stack).map(t -> t.func_74762_e(this.getNbtKeyEnergy())).orElse(0);
    }

    public void setEnergyStored(int amount) {
        ItemUtils.getOrCreateTag((ItemStack)this.stack).func_74768_a(this.getNbtKeyEnergy(), amount);
    }

    public boolean canExtract() {
        return true;
    }

    public boolean canReceive() {
        return true;
    }
}

