/*
 * Decompiled with CFR 0.152.
 */
package xyz.phanta.tconevo.artifact;

import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import io.github.phantamanta44.libnine.util.TriBool;
import java.util.Collection;
import java.util.Objects;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import xyz.phanta.tconevo.TconEvoMod;
import xyz.phanta.tconevo.artifact.type.ArtifactType;

public class Artifact<T>
extends LootEntry {
    private final ArtifactType<T> type;
    private final T spec;
    @Nullable
    private ItemStack stack;
    private TriBool valid = TriBool.NONE;

    public Artifact(String id, ArtifactType<T> type, T spec, int weight) {
        super(weight, 0, new LootCondition[]{TconEvoMod.PROXY.getArtifactRegistry().getLootCondition(id)}, id);
        this.type = type;
        this.spec = spec;
    }

    public void initialize() throws ArtifactType.BuildingException {
        if (this.valid != TriBool.NONE) {
            throw new IllegalStateException("Artifact is already initialized: " + this.getEntryName());
        }
        try {
            this.stack = this.type.buildArtifact(this.spec);
        }
        catch (ArtifactType.BuildingException e) {
            this.valid = TriBool.FALSE;
            throw e;
        }
        this.valid = TriBool.TRUE;
    }

    public boolean isValid() {
        return this.stack != null && !this.stack.func_190926_b();
    }

    public ItemStack newStack() {
        if (this.valid == TriBool.NONE) {
            TconEvoMod.LOGGER.warn("Artifact was used before it was initialized: " + this.getEntryName(), (Throwable)new IllegalStateException());
            return ItemStack.field_190927_a;
        }
        return this.valid.value ? Objects.requireNonNull(this.stack).func_77946_l() : ItemStack.field_190927_a;
    }

    public void func_186363_a(Collection<ItemStack> stacks, Random rand, LootContext context) {
        if (this.valid == TriBool.NONE) {
            TconEvoMod.LOGGER.warn("Artifact was used before it was initialized: " + this.getEntryName(), (Throwable)new IllegalStateException());
        } else if (this.valid.value) {
            stacks.add(Objects.requireNonNull(this.stack).func_77946_l());
        }
    }

    protected void func_186362_a(JsonObject json, JsonSerializationContext context) {
        throw new UnsupportedOperationException();
    }
}

