/*
 * Decompiled with CFR 0.152.
 */
package xyz.phanta.tconevo.artifact;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import xyz.phanta.tconevo.TconEvoConfig;
import xyz.phanta.tconevo.TconEvoMod;
import xyz.phanta.tconevo.artifact.Artifact;
import xyz.phanta.tconevo.artifact.ArtifactLoader;
import xyz.phanta.tconevo.artifact.type.ArtifactType;
import xyz.phanta.tconevo.artifact.type.ArtifactTypeRegistry;

public class ArtifactRegistry {
    private final ArtifactLoader loader = new ArtifactLoader();
    private final ArtifactTypeRegistry typeRegistry = new ArtifactTypeRegistry();
    private final Map<String, Artifact<?>> artifactRegistry = new HashMap();
    private boolean artifactsLoaded = false;

    public ArtifactLoader getLoader() {
        return this.loader;
    }

    public ArtifactTypeRegistry getTypeRegistry() {
        return this.typeRegistry;
    }

    void registerArtifacts(Collection<Artifact<?>> artifacts) {
        this.artifactRegistry.clear();
        for (Artifact<?> artifact : artifacts) {
            this.artifactRegistry.put(artifact.getEntryName(), artifact);
        }
        this.artifactsLoaded = true;
    }

    public void initArtifacts() {
        if (!TconEvoConfig.artifacts.enabled) {
            return;
        }
        TconEvoMod.LOGGER.info("Initializing artifacts...");
        for (Artifact<?> artifact : this.artifactRegistry.values()) {
            TconEvoMod.LOGGER.debug("Initializing artifact: {}", (Object)artifact.getEntryName());
            try {
                artifact.initialize();
            }
            catch (ArtifactType.BuildingException e) {
                TconEvoMod.LOGGER.warn("Failed to initialize artifact \"{}\": {}", (Object)artifact.getEntryName(), (Object)e.getMessage());
            }
            catch (Exception e) {
                TconEvoMod.LOGGER.warn("Encountered exception while initializing artifact: " + artifact.getEntryName(), (Throwable)e);
            }
        }
    }

    @Nullable
    public Artifact<?> getArtifact(String id) {
        if (!this.artifactsLoaded) {
            TconEvoMod.LOGGER.error("Artifacts were looked up before being loaded!", (Throwable)new IllegalStateException());
            return null;
        }
        return this.artifactRegistry.get(id);
    }

    public Set<String> getAllArtifactIds() {
        if (!this.artifactsLoaded) {
            TconEvoMod.LOGGER.error("Artifacts were looked up before being loaded!", (Throwable)new IllegalStateException());
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(this.artifactRegistry.keySet());
    }

    public Collection<Artifact<?>> getAllArtifacts() {
        if (!this.artifactsLoaded) {
            TconEvoMod.LOGGER.error("Artifacts were looked up before being loaded!", (Throwable)new IllegalStateException());
            return Collections.emptyList();
        }
        return Collections.unmodifiableCollection(this.artifactRegistry.values());
    }

    public LootCondition getLootCondition(String id) {
        return new ConditionArtifactExists(id);
    }

    private class ConditionArtifactExists
    implements LootCondition {
        private final String id;

        ConditionArtifactExists(String id) {
            this.id = id;
        }

        public boolean func_186618_a(Random rand, LootContext context) {
            Artifact<?> artifact = ArtifactRegistry.this.getArtifact(this.id);
            return artifact != null && artifact.isValid();
        }
    }
}

