/*
 * Decompiled with CFR 0.152.
 */
package xyz.phanta.tconevo.artifact.type;

import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import xyz.phanta.tconevo.artifact.Artifact;
import xyz.phanta.tconevo.artifact.type.ArtifactType;
import xyz.phanta.tconevo.artifact.type.ArtifactTypeArmour;
import xyz.phanta.tconevo.artifact.type.ArtifactTypeTool;

public class ArtifactTypeRegistry {
    private final Map<ResourceLocation, ArtifactType<?>> typeRegistry = new HashMap();

    public ArtifactTypeRegistry() {
        this.registerArtifactType(new ResourceLocation("tconevo", "tool"), new ArtifactTypeTool());
        this.registerArtifactType(new ResourceLocation("tconevo", "armour"), new ArtifactTypeArmour());
    }

    public void registerArtifactType(ResourceLocation typeId, ArtifactType<?> type) {
        this.typeRegistry.put(typeId, type);
    }

    @Nullable
    public ArtifactType<?> getArtifactType(ResourceLocation typeId) {
        return this.typeRegistry.get(typeId);
    }

    @Nullable
    public Artifact<?> parseArtifact(String artifactId, JsonObject dto) throws ArtifactType.BuildingException {
        ArtifactType<?> type = this.getArtifactType(new ResourceLocation(JsonUtils.func_151200_h((JsonObject)dto, (String)"type")));
        return type != null ? ArtifactTypeRegistry.constructArtifact(artifactId, type, dto) : null;
    }

    private static <T> Artifact<T> constructArtifact(String artifactId, ArtifactType<T> type, JsonObject dto) throws ArtifactType.BuildingException {
        return new Artifact<T>(artifactId, type, type.parseArtifactSpec(dto), JsonUtils.func_151203_m((JsonObject)dto, (String)"weight"));
    }
}

