/*
 * Decompiled with CFR 0.152.
 */
package xyz.phanta.tconevo.artifact.type;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import io.github.phantamanta44.libnine.util.helper.ItemUtils;
import io.github.phantamanta44.libnine.util.helper.JsonUtils9;
import io.github.phantamanta44.libnine.util.nbt.ImmutableNbt;
import io.github.phantamanta44.libnine.util.tuple.IPair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.NonNullList;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.events.TinkerCraftingEvent;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.library.modifiers.IModifier;
import slimeknights.tconstruct.library.modifiers.TinkerGuiException;
import slimeknights.tconstruct.library.tinkering.PartMaterialType;
import slimeknights.tconstruct.library.tools.IToolPart;
import slimeknights.tconstruct.library.tools.ToolCore;
import slimeknights.tconstruct.library.utils.TagUtil;
import slimeknights.tconstruct.tools.TinkerModifiers;
import xyz.phanta.tconevo.TconEvoConfig;
import xyz.phanta.tconevo.artifact.type.ArtifactType;
import xyz.phanta.tconevo.init.TconEvoTraits;
import xyz.phanta.tconevo.integration.gamestages.GameStagesHooks;
import xyz.phanta.tconevo.util.ToolUtils;

public class ArtifactTypeTool
implements ArtifactType<Spec> {
    @Override
    public Spec parseArtifactSpec(JsonObject dto) {
        return new Spec(JsonUtils.func_151200_h((JsonObject)dto, (String)"name"), ArtifactTypeTool.parseLore(dto), JsonUtils.func_151200_h((JsonObject)dto, (String)"tool"), ArtifactTypeTool.parseMaterials(dto), JsonUtils.func_151208_a((JsonObject)dto, (String)"free_mods", (int)0), ArtifactTypeTool.parseModifiers(dto), JsonUtils.func_151218_a((JsonObject)dto, (String)"data_tag", null));
    }

    public static List<String> parseLore(JsonObject dto) {
        if (!dto.has("lore")) {
            return Collections.emptyList();
        }
        JsonElement loreDto = dto.get("lore");
        if (loreDto.isJsonArray()) {
            ArrayList<String> lore = new ArrayList<String>();
            for (JsonElement loreLineDto : loreDto.getAsJsonArray()) {
                if (loreLineDto.isJsonPrimitive() && loreLineDto.getAsJsonPrimitive().isString()) {
                    lore.add(loreLineDto.getAsString());
                    continue;
                }
                throw new JsonSyntaxException("Expected a string in the \"lore\" array, but got: " + loreLineDto);
            }
            return lore;
        }
        if (loreDto.isJsonPrimitive() && loreDto.getAsJsonPrimitive().isString()) {
            return Collections.singletonList(loreDto.getAsString());
        }
        throw new JsonSyntaxException("Expected either a string array or a string for \"lore\", but got " + loreDto);
    }

    public static List<String> parseMaterials(JsonObject dto) {
        return JsonUtils9.stream((JsonArray)dto.getAsJsonArray("materials")).map(s -> {
            if (s.isJsonPrimitive() && s.getAsJsonPrimitive().isString()) {
                return s.getAsString();
            }
            throw new JsonSyntaxException("Expected a string in the \"materials\" array, but got: " + s);
        }).collect(Collectors.toList());
    }

    public static List<IPair<String, Integer>> parseModifiers(JsonObject dto) {
        if (!dto.has("mods")) {
            return Collections.emptyList();
        }
        ArrayList<IPair<String, Integer>> modifiers = new ArrayList<IPair<String, Integer>>();
        for (JsonElement modDto : JsonUtils.func_151214_t((JsonObject)dto, (String)"mods")) {
            if (modDto.isJsonObject()) {
                JsonObject modDtoObj = modDto.getAsJsonObject();
                modifiers.add((IPair<String, Integer>)IPair.of((Object)JsonUtils.func_151200_h((JsonObject)modDtoObj, (String)"id"), (Object)JsonUtils.func_151208_a((JsonObject)modDtoObj, (String)"level", (int)1)));
                continue;
            }
            if (modDto.isJsonPrimitive() && modDto.getAsJsonPrimitive().isString()) {
                modifiers.add((IPair<String, Integer>)IPair.of((Object)modDto.getAsString(), (Object)1));
                continue;
            }
            throw new JsonSyntaxException("Expected either a modifier object or a string in \"mods\", but got " + modDto);
        }
        return modifiers;
    }

    @Override
    public ItemStack buildArtifact(Spec spec) throws ArtifactType.BuildingException {
        ToolCore toolType = TinkerRegistry.getTools().stream().filter(t -> t.getIdentifier().equals(spec.toolType)).findAny().orElseThrow(() -> new ArtifactType.BuildingException("Unknown tool type \"%s\"", spec.toolType));
        List componentTypes = toolType.getRequiredComponents();
        if (spec.materials.size() != componentTypes.size()) {
            throw new ArtifactType.BuildingException("Needed %d materials but got %d for tool type \"%s\"", componentTypes.size(), spec.materials.size(), toolType.getIdentifier());
        }
        List<Material> materials = ArtifactTypeTool.resolveMaterials(spec.materials);
        NonNullList components = NonNullList.func_191196_a();
        for (int i = 0; i < materials.size(); ++i) {
            Set parts = ((PartMaterialType)componentTypes.get(i)).getPossibleParts();
            if (parts.isEmpty()) {
                throw new ArtifactType.BuildingException("Unsatisfiable part %d for tool type \"%s\"", i, toolType.getIdentifier());
            }
            components.add((Object)((IToolPart)parts.iterator().next()).getItemstackWithMaterial(materials.get(i)));
        }
        ItemStack stack = toolType.buildItem(materials);
        stack.func_151001_c(ARTIFACT_FMT + spec.name);
        try {
            GameStagesHooks.INSTANCE.startBypass();
            TinkerCraftingEvent.ToolCraftingEvent.fireEvent((ItemStack)stack, null, (NonNullList)components);
        }
        catch (TinkerGuiException e) {
            throw new ArtifactType.BuildingException("Tool building produced error: %s", e.getMessage());
        }
        finally {
            GameStagesHooks.INSTANCE.endBypass();
        }
        ItemStack stackPreMods = stack.func_77946_l();
        if (TconEvoConfig.artifacts.freeModBaseline >= 0) {
            NBTTagCompound toolTag = TagUtil.getToolTag((ItemStack)stack);
            for (int i = toolTag.func_74762_e("FreeModifiers"); i < TconEvoConfig.artifacts.freeModBaseline; ++i) {
                TinkerModifiers.modCreative.apply(stack);
            }
        }
        for (int i = spec.freeMods; i > 0; --i) {
            TinkerModifiers.modCreative.apply(stack);
        }
        ArtifactTypeTool.applyModifiers(spec.modifiers, stack);
        try {
            GameStagesHooks.INSTANCE.startBypass();
            TinkerCraftingEvent.ToolModifyEvent.fireEvent((ItemStack)stack, null, (ItemStack)stackPreMods.func_77946_l());
            TconEvoTraits.MOD_ARTIFACT.apply(stack);
            ToolUtils.rebuildToolStack(stack);
        }
        catch (TinkerGuiException e) {
            throw new ArtifactType.BuildingException("Tool modification produced error: %s", e.getMessage());
        }
        finally {
            GameStagesHooks.INSTANCE.endBypass();
        }
        ArtifactTypeTool.addExtraItemData(stack, spec.lore, spec.dataTag);
        return stack;
    }

    public static List<Material> resolveMaterials(List<String> materialIds) throws ArtifactType.BuildingException {
        ArrayList<Material> materials = new ArrayList<Material>();
        for (String materialId : materialIds) {
            Material material = TinkerRegistry.getMaterial((String)materialId);
            if (material == Material.UNKNOWN) {
                throw new ArtifactType.BuildingException("Unknown material \"%s\"", materialId);
            }
            materials.add(material);
        }
        return materials;
    }

    public static void applyModifiers(List<IPair<String, Integer>> modEntries, ItemStack stack) throws ArtifactType.BuildingException {
        for (IPair<String, Integer> modEntry : modEntries) {
            IModifier mod = TinkerRegistry.getModifier((String)((String)modEntry.getA()));
            if (mod == null) {
                throw new ArtifactType.BuildingException("Unknown modifier \"%s\"", modEntry.getA());
            }
            for (int i = ((Integer)modEntry.getB()).intValue(); i > 0; --i) {
                mod.apply(stack);
            }
        }
    }

    public static void addExtraItemData(ItemStack stack, List<String> lore, @Nullable ImmutableNbt<NBTTagCompound> dataTag) {
        NBTTagCompound tag = ItemUtils.getOrCreateTag((ItemStack)stack);
        if (!lore.isEmpty()) {
            NBTTagCompound displayTag;
            if (tag.func_74764_b("display")) {
                displayTag = tag.func_74775_l("display");
            } else {
                displayTag = new NBTTagCompound();
                tag.func_74782_a("display", (NBTBase)displayTag);
            }
            NBTTagList loreTag = new NBTTagList();
            loreTag.func_74742_a((NBTBase)new NBTTagString());
            for (String line : lore) {
                loreTag.func_74742_a((NBTBase)new NBTTagString(LORE_FMT + line));
            }
            displayTag.func_74782_a("Lore", (NBTBase)loreTag);
        }
        if (dataTag != null) {
            stack.func_77982_d((NBTTagCompound)dataTag.write((NBTBase)tag));
        }
    }

    public static class Spec {
        public final String name;
        public final List<String> lore;
        public final String toolType;
        public final List<String> materials;
        public final int freeMods;
        public final List<IPair<String, Integer>> modifiers;
        @Nullable
        public final ImmutableNbt<NBTTagCompound> dataTag;

        public Spec(String name, List<String> lore, String toolType, List<String> materials, int freeMods, List<IPair<String, Integer>> modifiers, @Nullable JsonObject dataTag) {
            this.name = name;
            this.lore = Collections.unmodifiableList(lore);
            this.toolType = toolType;
            this.materials = Collections.unmodifiableList(materials);
            this.freeMods = freeMods;
            this.modifiers = Collections.unmodifiableList(modifiers);
            this.dataTag = dataTag != null ? ImmutableNbt.parseObject((JsonObject)dataTag) : null;
        }
    }
}

