/*
 * Decompiled with CFR 0.152.
 */
package xyz.phanta.tconevo.block;

import io.github.phantamanta44.libnine.block.L9BlockStated;
import io.github.phantamanta44.libnine.client.model.ParameterizedItemModel;
import io.github.phantamanta44.libnine.item.L9ItemBlock;
import io.github.phantamanta44.libnine.item.L9ItemBlockStated;
import io.github.phantamanta44.libnine.util.collection.Accrue;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import slimeknights.tconstruct.world.TinkerWorld;
import xyz.phanta.tconevo.init.TconEvoBlocks;

public class BlockEarthMaterial
extends L9BlockStated {
    public static final IProperty<Type> TYPE = PropertyEnum.func_177709_a((String)"type", Type.class);

    public BlockEarthMaterial() {
        super("earth_material_block", Material.field_151595_p);
        this.func_149711_c(3.0f);
        this.setDefaultSlipperiness(0.8f);
        this.func_149672_a(SoundType.field_185855_h);
        this.setHarvestLevel("shovel", -1);
    }

    protected void accrueProperties(Accrue<IProperty<?>> props) {
        props.accept(TYPE);
    }

    protected L9ItemBlock initItemBlock() {
        return new ItemBlockEarthMaterial(this);
    }

    public void func_176199_a(World world, BlockPos pos, Entity entity) {
        entity.field_70159_w *= 0.4;
        entity.field_70179_y *= 0.4;
        if (entity instanceof EntityLivingBase) {
            ((EntityLivingBase)entity).func_70690_d(new PotionEffect(MobEffects.field_76437_t, 1));
        }
    }

    public boolean canSustainPlant(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing direction, IPlantable plantable) {
        return plantable.getPlantType(world, pos) == TinkerWorld.slimePlantType;
    }

    private static class ItemBlockEarthMaterial
    extends L9ItemBlockStated
    implements ParameterizedItemModel.IParamaterized {
        ItemBlockEarthMaterial(BlockEarthMaterial block) {
            super((L9BlockStated)block);
        }

        public void getModelMutations(ItemStack stack, ParameterizedItemModel.Mutation m) {
            m.mutate("type", Type.getForStack(stack).name());
        }
    }

    public static enum Type implements IStringSerializable
    {
        PINK_SLIMY_MUD;

        public static final Type[] VALUES;

        public static Type getForMeta(int meta) {
            return meta >= 0 && meta < VALUES.length ? VALUES[meta] : PINK_SLIMY_MUD;
        }

        public static Type getForStack(ItemStack stack) {
            return Type.getForMeta(stack.func_77960_j());
        }

        public String func_176610_l() {
            return this.name().toLowerCase();
        }

        public int getMeta() {
            return this.ordinal();
        }

        public ItemStack newStack(int count) {
            return new ItemStack((Block)TconEvoBlocks.EARTH_MATERIAL, count, this.getMeta());
        }

        static {
            VALUES = Type.values();
        }
    }
}

