/*
 * Decompiled with CFR 0.152.
 */
package xyz.phanta.tconevo.capability;

import io.github.phantamanta44.libnine.util.helper.OptUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityLivingBase;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import xyz.phanta.tconevo.capability.EuStore;
import xyz.phanta.tconevo.capability.RatedEnergyStorage;
import xyz.phanta.tconevo.init.TconEvoCaps;

public abstract class PowerWrapper {
    public static final double RF_PER_EU = 2.5;
    @Nullable
    private static Map<Capability<?>, Function<ICapabilityProvider, PowerWrapper>> wrapperFactories = null;

    @Nullable
    private static Function<ICapabilityProvider, PowerWrapper> getFactory(ICapabilityProvider obj) {
        if (wrapperFactories == null) {
            wrapperFactories = new HashMap();
            wrapperFactories.put(CapabilityEnergy.ENERGY, c -> OptUtils.capability((ICapabilityProvider)c, (Capability)CapabilityEnergy.ENERGY).map(Fluxed::new).orElse(null));
            wrapperFactories.put(TconEvoCaps.EU_STORE, c -> OptUtils.capability((ICapabilityProvider)c, TconEvoCaps.EU_STORE).map(Electric::new).orElse(null));
        }
        for (Map.Entry<Capability<?>, Function<ICapabilityProvider, PowerWrapper>> entry : wrapperFactories.entrySet()) {
            if (!obj.hasCapability(entry.getKey(), null)) continue;
            return entry.getValue();
        }
        return null;
    }

    @Nullable
    public static PowerWrapper wrap(ICapabilityProvider obj) {
        Function<ICapabilityProvider, PowerWrapper> factory = PowerWrapper.getFactory(obj);
        return factory != null ? factory.apply(obj) : null;
    }

    public static boolean isPowered(ICapabilityProvider obj) {
        return PowerWrapper.getFactory(obj) != null;
    }

    public abstract int getEnergy();

    public abstract int getEnergyMax();

    public abstract int inject(int var1, boolean var2, boolean var3);

    public abstract int extract(int var1, boolean var2, boolean var3);

    public boolean consume(int amount, EntityLivingBase user, boolean commit) {
        return this.extract(amount, commit, true) >= amount;
    }

    private static class Electric
    extends PowerWrapper {
        private final EuStore energy;

        Electric(EuStore energy) {
            this.energy = energy;
        }

        @Override
        public int getEnergy() {
            return (int)Math.floor(this.energy.getEuStored() * 2.5);
        }

        @Override
        public int getEnergyMax() {
            return (int)Math.ceil(this.energy.getEuStoredMax() * 2.5);
        }

        @Override
        public int inject(int amount, boolean commit, boolean ignoreTfrRate) {
            return (int)Math.ceil(this.energy.injectEu((double)amount / 2.5, ignoreTfrRate, commit) * 2.5);
        }

        @Override
        public int extract(int amount, boolean commit, boolean ignoreTfrRate) {
            return (int)Math.floor(this.energy.extractEu((double)amount / 2.5, ignoreTfrRate, commit) * 2.5);
        }

        @Override
        public boolean consume(int amount, EntityLivingBase user, boolean commit) {
            return this.energy.consumeEu((double)amount / 2.5, user, commit);
        }
    }

    private static class Fluxed
    extends PowerWrapper {
        private final IEnergyStorage energy;

        Fluxed(IEnergyStorage energy) {
            this.energy = energy;
        }

        @Override
        public int getEnergy() {
            return this.energy.getEnergyStored();
        }

        @Override
        public int getEnergyMax() {
            return this.energy.getMaxEnergyStored();
        }

        @Override
        public int inject(int amount, boolean commit, boolean ignoreTfrRate) {
            return this.energy instanceof RatedEnergyStorage ? ((RatedEnergyStorage)this.energy).receiveEnergy(amount, !commit, ignoreTfrRate) : this.energy.receiveEnergy(amount, !commit);
        }

        @Override
        public int extract(int amount, boolean commit, boolean ignoreTfrRate) {
            return this.energy instanceof RatedEnergyStorage ? ((RatedEnergyStorage)this.energy).extractEnergy(amount, !commit, ignoreTfrRate) : this.energy.extractEnergy(amount, !commit);
        }
    }
}

