/*
 * Decompiled with CFR 0.152.
 */
package xyz.phanta.tconevo.client.gui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.client.material.MaterialRenderInfoLoader;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.library.tools.IToolPart;
import slimeknights.tconstruct.tools.TinkerTools;
import slimeknights.tconstruct.tools.common.client.GuiButtonItem;
import xyz.phanta.tconevo.TconEvoMod;
import xyz.phanta.tconevo.client.util.ArbitraryTexture;

public class GuiPreviewMaterialRender
extends GuiScreen {
    private static final String LOC_BASE = "tconevo.gui.preview_material_render.";
    private static final String LOC_REFRESH = "tconevo.gui.preview_material_render.refresh";
    private static final String LOC_NOTHING_TO_RENDER = "tconevo.gui.preview_material_render.nothing_to_render";
    private static final ArbitraryTexture partTexture = new ArbitraryTexture();
    private final Material material;
    private final List<IToolPart> validParts;
    private IToolPart part;

    public GuiPreviewMaterialRender(Material material, @Nullable IToolPart part) {
        this.material = material;
        this.validParts = new ArrayList<IToolPart>();
        for (IToolPart possiblePart : TinkerRegistry.getToolParts()) {
            if (!possiblePart.canUseMaterial(material)) continue;
            this.validParts.add(possiblePart);
        }
        this.part = part != null ? part : TinkerTools.largePlate;
        partTexture.clear();
    }

    public void func_73866_w_() {
        this.refreshRender();
        int x = this.field_146294_l / 2 - 116;
        int y = this.field_146295_m / 2 - 100;
        int btnNdx = 0;
        for (IToolPart part : this.validParts) {
            this.func_189646_b((GuiButton)new GuiButtonItem(btnNdx++, x, y, part.getItemstackWithMaterial(this.material), (Object)part));
            if (btnNdx % 10 == 0) {
                x -= 20;
                y -= 180;
                continue;
            }
            y += 20;
        }
        this.func_189646_b(new GuiButton(-1, this.field_146294_l / 2 - 72, this.field_146295_m / 2 + 52, 144, 20, I18n.func_135052_a((String)LOC_REFRESH, (Object[])new Object[0])));
    }

    protected void func_146284_a(GuiButton button) {
        if (button.field_146127_k == -1) {
            MaterialRenderInfoLoader.INSTANCE.loadRenderInfo();
            this.refreshRender();
        } else if (button instanceof GuiButtonItem) {
            this.part = (IToolPart)((GuiButtonItem)button).data;
            this.refreshRender();
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)((float)this.field_146294_l / 2.0f), (float)((float)this.field_146295_m / 2.0f), (float)0.0f);
        GlStateManager.func_179094_E();
        GlStateManager.func_179152_a((float)2.0f, (float)2.0f, (float)1.0f);
        this.func_73732_a(this.field_146289_q, this.material.getLocalizedName(), 0, -36, 0xFFFFFF);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (partTexture.isValid()) {
            GlStateManager.func_179152_a((float)2.0f, (float)2.0f, (float)1.0f);
            GlStateManager.func_179144_i((int)partTexture.func_110552_b());
            Tessellator tess = Tessellator.func_178181_a();
            BufferBuilder buf = tess.func_178180_c();
            buf.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            buf.func_181662_b(-8.0, -8.0, 0.0).func_187315_a(0.0, 0.0).func_181675_d();
            buf.func_181662_b(-8.0, 8.0, 0.0).func_187315_a(0.0, 1.0).func_181675_d();
            buf.func_181662_b(8.0, 8.0, 0.0).func_187315_a(1.0, 1.0).func_181675_d();
            buf.func_181662_b(8.0, -8.0, 0.0).func_187315_a(1.0, 0.0).func_181675_d();
            tess.func_78381_a();
            GlStateManager.func_179121_F();
        } else {
            GlStateManager.func_179121_F();
            this.func_73732_a(this.field_146289_q, I18n.func_135052_a((String)LOC_NOTHING_TO_RENDER, (Object[])new Object[0]), 0, -4, 0xFF0000);
        }
        GlStateManager.func_179121_F();
    }

    private void refreshRender() {
        if (this.material.renderInfo == null) {
            partTexture.clear();
            return;
        }
        try {
            TextureAtlasSprite baseSprite = this.field_146297_k.func_175599_af().func_184393_a(this.part.getItemstackWithMaterial(this.material), null, null).func_177554_e();
            Collection dependencyTextures = baseSprite.getDependencies();
            ResourceLocation baseTexture = dependencyTextures.isEmpty() ? new ResourceLocation(baseSprite.func_94215_i()) : (ResourceLocation)dependencyTextures.iterator().next();
            TextureAtlasSprite sprite = this.material.renderInfo.getTexture(baseTexture, baseTexture + "_" + this.material.identifier);
            IResourceManager resourceManager = this.field_146297_k.func_110442_L();
            TextureMap texMap = this.field_146297_k.func_147117_R();
            sprite.load(resourceManager, baseTexture, id -> texMap.getTextureExtry(id.toString()));
            if (sprite.func_110970_k() > 0) {
                partTexture.write(sprite.func_94211_a(), sprite.func_94216_b(), sprite.func_147965_a(0)[0]);
            } else {
                partTexture.clear();
            }
        }
        catch (Exception e) {
            TconEvoMod.LOGGER.warn("Failed to load tool part render!", (Throwable)e);
            partTexture.clear();
        }
    }
}

