/*
 * Decompiled with CFR 0.152.
 */
package xyz.phanta.tconevo.client.handler;

import io.github.phantamanta44.libnine.util.format.FormatUtils;
import io.github.phantamanta44.libnine.util.helper.OptUtils;
import java.awt.Color;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import slimeknights.tconstruct.library.client.CustomFontColor;
import slimeknights.tconstruct.library.tinkering.ITinkerable;
import slimeknights.tconstruct.library.traits.ITrait;
import slimeknights.tconstruct.library.utils.ToolHelper;
import xyz.phanta.tconevo.trait.base.EnergeticModifier;

public class EnergyTooltipHandler {
    @SubscribeEvent
    public void onTooltip(ItemTooltipEvent event) {
        ItemStack stack = event.getItemStack();
        if (EnergyTooltipHandler.shouldDrawEnergyTooltip(stack)) {
            OptUtils.capability((ICapabilityProvider)stack, (Capability)CapabilityEnergy.ENERGY).ifPresent(energy -> {
                int stored = energy.getEnergyStored();
                int max = energy.getMaxEnergyStored();
                event.getToolTip().add(1, String.format("%s%s / %s", CustomFontColor.encodeColor((int)Color.HSBtoRGB(0.33f * (float)stored / (float)max, 1.0f, 0.67f)), FormatUtils.formatSI((int)stored, (String)"RF"), FormatUtils.formatSI((int)max, (String)"RF")));
            });
        }
    }

    private static boolean shouldDrawEnergyTooltip(ItemStack stack) {
        if (!(stack.func_77973_b() instanceof ITinkerable)) {
            return false;
        }
        for (ITrait trait : ToolHelper.getTraits((ItemStack)stack)) {
            if (!(trait instanceof EnergeticModifier) || ((EnergeticModifier)trait).getEnergyType() != EnergeticModifier.EnergyType.FORGE_ENERGY) continue;
            return true;
        }
        return false;
    }
}

