/*
 * Decompiled with CFR 0.152.
 */
package xyz.phanta.tconevo.client.render.material;

import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.ResourceLocation;
import slimeknights.tconstruct.library.client.MaterialRenderInfo;
import slimeknights.tconstruct.library.client.material.deserializers.AbstractRenderInfoDeserializer;
import xyz.phanta.tconevo.client.render.texture.EdgeFindingTexture;
import xyz.phanta.tconevo.client.util.RenderUtilsEx;

public class EdgeColourMaterialRenderInfo
extends MaterialRenderInfo.AbstractMaterialRenderInfo {
    private final int inner;
    private final int outer;
    private final float bleed;

    public EdgeColourMaterialRenderInfo(int inner, int outer, float bleed) {
        this.inner = inner;
        this.outer = outer | 0xFF000000;
        this.bleed = bleed;
    }

    public TextureAtlasSprite getTexture(ResourceLocation baseTexture, String location) {
        return new EdgeColourTexture(baseTexture, location);
    }

    public static class Deserializer
    extends AbstractRenderInfoDeserializer {
        private String inner;
        private String outer;
        private float bleed;

        public MaterialRenderInfo getMaterialRenderInfo() {
            return new EdgeColourMaterialRenderInfo(this.fromHex(this.inner), this.fromHex(this.outer), this.bleed);
        }
    }

    private class EdgeColourTexture
    extends EdgeFindingTexture {
        protected EdgeColourTexture(ResourceLocation baseTextureLocation, String spriteName) {
            super(baseTextureLocation, spriteName);
        }

        @Override
        protected int processEdgePixel(int colour) {
            return RenderUtilsEx.tintColour(EdgeColourMaterialRenderInfo.this.outer, colour, EdgeColourMaterialRenderInfo.this.bleed);
        }

        @Override
        protected int processInnerPixel(int colour) {
            return RenderUtilsEx.multiplyColours(EdgeColourMaterialRenderInfo.this.inner, colour);
        }
    }
}

