/*
 * Decompiled with CFR 0.152.
 */
package xyz.phanta.tconevo.client.util;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import xyz.phanta.tconevo.client.util.DelegatingModel;

public abstract class DelegateModelCache<K, M extends DelegatingModel<K, M>>
extends ItemOverrideList {
    private final M rootModel;
    private final Cache<K, M> delegateCache = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterWrite(5L, TimeUnit.MINUTES).build();
    @Nullable
    private World cachedRenderWorld = null;
    @Nullable
    private EntityLivingBase cachedRenderEntity = null;
    @Nullable
    private BlockPos cachedRenderEntityPos = null;

    public DelegateModelCache(M rootModel) {
        this.rootModel = rootModel;
    }

    public M getRootModel() {
        return this.rootModel;
    }

    protected abstract K extractDelegateKey(IBakedModel var1, ItemStack var2, @Nullable World var3, @Nullable EntityLivingBase var4);

    public IBakedModel handleItemState(IBakedModel originalModel, ItemStack stack, @Nullable World world, @Nullable EntityLivingBase entity) {
        this.cachedRenderWorld = world;
        this.cachedRenderEntity = entity;
        this.cachedRenderEntityPos = entity != null ? entity.func_180425_c() : null;
        return this.getWrappedDelegate(this.extractDelegateKey(this.rootModel.getParentModel(), stack, world, entity));
    }

    public IBakedModel getWrappedDelegate(K delegateKey) {
        try {
            return (IBakedModel)this.delegateCache.get(delegateKey, () -> this.rootModel.wrapDelegate(delegateKey));
        }
        catch (ExecutionException e) {
            throw new IllegalStateException("Delegate model override cache lookup failed!", e.getCause());
        }
    }

    @Nullable
    public World getCachedWorld() {
        return this.cachedRenderWorld;
    }

    @Nullable
    public EntityLivingBase getCachedEntity() {
        return this.cachedRenderEntity;
    }

    @Nullable
    public BlockPos getCachedEntityPos() {
        return this.cachedRenderEntityPos;
    }

    public static class Overriding<M extends DelegatingModel<IBakedModel, M>>
    extends DelegateModelCache<IBakedModel, M> {
        public Overriding(M rootModel) {
            super(rootModel);
        }

        @Override
        protected IBakedModel extractDelegateKey(IBakedModel parent, ItemStack stack, @Nullable World world, @Nullable EntityLivingBase entity) {
            return parent.func_188617_f().handleItemState(parent, stack, world, entity);
        }
    }
}

