/*
 * Decompiled with CFR 0.152.
 */
package xyz.phanta.tconevo.coremod.transform;

import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import xyz.phanta.tconevo.coremod.TconEvoClassTransformer;

public class TransformFixDraconicJei
implements TconEvoClassTransformer.Transform {
    @Override
    public String getName() {
        return "Fix Draconic Evolution JEI";
    }

    @Override
    public int getWriteFlags() {
        return 2;
    }

    @Override
    public void getClasses(Consumer<String> collector) {
        collector.accept("com.brandon3055.draconicevolution.integration.jei.FusionRecipeCategory");
    }

    @Override
    public ClassVisitor createTransformer(String className, int apiVersion, ClassVisitor downstream) {
        return new ClassTransformerFusionRecipeCategory(apiVersion, downstream);
    }

    private static class MethodTransformerSetRecipe
    extends MethodVisitor {
        private State state = State.INITIAL;
        private int recipeVar = -1;
        @Nullable
        private Label ifEndLabel = null;

        public MethodTransformerSetRecipe(int api, MethodVisitor downstream) {
            super(api, downstream);
        }

        public void visitFieldInsn(int opcode, String owner, String name, String desc) {
            if (this.state == State.INITIAL && opcode == 180 && owner.equals("com/brandon3055/draconicevolution/integration/jei/FusionRecipeWrapper") && name.equals("recipe")) {
                this.state = State.SEEN_GET_RECIPE;
            }
            super.visitFieldInsn(opcode, owner, name, desc);
        }

        public void visitVarInsn(int opcode, int var) {
            if (this.state == State.SEEN_GET_RECIPE && opcode == 58) {
                this.state = State.GOT_RECIPE;
                this.recipeVar = var;
            }
            super.visitVarInsn(opcode, var);
        }

        public void visitTypeInsn(int opcode, String type) {
            if (this.state == State.GOT_RECIPE && opcode == 193 && type.equals("com/brandon3055/draconicevolution/api/itemupgrade/FusionUpgradeRecipe")) {
                this.state = State.SEEN_INST_CHECK;
            }
            super.visitTypeInsn(opcode, type);
        }

        public void visitJumpInsn(int opcode, Label label) {
            if (this.state == State.SEEN_INST_CHECK && opcode == 153) {
                this.state = State.SEEN_BRANCH;
                this.ifEndLabel = label;
            }
            super.visitJumpInsn(opcode, label);
        }

        public void visitLabel(Label label) {
            super.visitLabel(label);
            switch (this.state) {
                case SEEN_GET_RECIPE: {
                    this.state = State.INITIAL;
                    break;
                }
                case SEEN_INST_CHECK: {
                    this.state = State.GOT_RECIPE;
                    break;
                }
                case SEEN_BRANCH: {
                    if (label != this.ifEndLabel) break;
                    this.state = State.DONE;
                    super.visitVarInsn(25, 1);
                    super.visitVarInsn(25, this.recipeVar);
                    super.visitMethodInsn(184, "xyz/phanta/tconevo/integration/draconicevolution/client/DraconicJeiCoreHooks", "fixFusionRecipe", "(Lmezz/jei/api/gui/IRecipeLayout;Lcom/brandon3055/draconicevolution/api/fusioncrafting/IFusionRecipe;)V", false);
                }
            }
        }

        private static enum State {
            INITIAL,
            SEEN_GET_RECIPE,
            GOT_RECIPE,
            SEEN_INST_CHECK,
            SEEN_BRANCH,
            DONE;

        }
    }

    private static class ClassTransformerFusionRecipeCategory
    extends ClassVisitor {
        public ClassTransformerFusionRecipeCategory(int api, ClassVisitor downstream) {
            super(api, downstream);
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            if (name.equals("setRecipe") && desc.equals("(Lmezz/jei/api/gui/IRecipeLayout;Lmezz/jei/api/recipe/IRecipeWrapper;Lmezz/jei/api/ingredients/IIngredients;)V")) {
                return new MethodTransformerSetRecipe(this.api, super.visitMethod(access, name, desc, signature, exceptions));
            }
            return super.visitMethod(access, name, desc, signature, exceptions);
        }
    }
}

