/*
 * Decompiled with CFR 0.152.
 */
package xyz.phanta.tconevo.coremod.transform;

import java.util.function.Consumer;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import xyz.phanta.tconevo.coremod.TconEvoClassTransformer;

public class TransformImprovedToolBuilding
implements TconEvoClassTransformer.Transform {
    @Override
    public String getName() {
        return "Improved Tool Building";
    }

    @Override
    public void getClasses(Consumer<String> collector) {
        collector.accept("slimeknights.tconstruct.library.utils.ToolBuilder");
        collector.accept("c4.conarm.lib.tinkering.ArmorBuilder");
    }

    @Override
    public ClassVisitor createTransformer(String className, int apiVersion, ClassVisitor downstream) {
        return new ClassTransformerToolBuilder(apiVersion, downstream);
    }

    private static class MethodTransformerRebuildTool
    extends MethodVisitor {
        private int lastVar = -1;
        private boolean go = false;

        public MethodTransformerRebuildTool(int api, MethodVisitor mv) {
            super(api, mv);
        }

        public void visitVarInsn(int opcode, int var) {
            if (opcode == 25) {
                this.lastVar = var;
            }
            super.visitVarInsn(opcode, var);
        }

        public void visitLdcInsn(Object cst) {
            if (this.lastVar != -1 && cst instanceof String && cst.equals("EnchantEffect")) {
                this.go = true;
            }
            super.visitLdcInsn(cst);
        }

        public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
            super.visitMethodInsn(opcode, owner, name, desc, itf);
            if (this.go && opcode == 182 && (name.equals("func_82580_o") || name.equals("removeTag")) && desc.equals("(Ljava/lang/String;)V")) {
                super.visitVarInsn(25, this.lastVar);
                super.visitLdcInsn((Object)"Unbreakable");
                super.visitMethodInsn(182, owner, name, "(Ljava/lang/String;)V", false);
            }
        }

        public void visitLineNumber(int line, Label start) {
            this.go = false;
            super.visitLineNumber(line, start);
        }
    }

    private static class MethodTransformerTryModifyTool
    extends MethodVisitor {
        private int state = -2;

        public MethodTransformerTryModifyTool(int api, MethodVisitor mv) {
            super(api, mv);
        }

        public void visitTypeInsn(int opcode, String type) {
            if (this.state == -2 && opcode == 192 && type.equals("slimeknights/mantle/util/RecipeMatch$Match")) {
                this.state = -1;
            }
            super.visitTypeInsn(opcode, type);
        }

        public void visitVarInsn(int opcode, int var) {
            if (this.state == -1 && opcode == 58) {
                this.state = var;
            }
            super.visitVarInsn(opcode, var);
        }

        public void visitLineNumber(int line, Label start) {
            if (this.state == -1) {
                this.state = -2;
            }
            super.visitLineNumber(line, start);
        }

        public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
            if (this.state > 0 && itf && opcode == 185 && owner.equals("slimeknights/tconstruct/library/modifiers/IModifier")) {
                switch (name) {
                    case "canApply": {
                        super.visitVarInsn(25, this.state);
                        super.visitMethodInsn(184, "xyz/phanta/tconevo/handler/ItemSensitiveModificationCoreHooks", "canApply", "(Lslimeknights/tconstruct/library/modifiers/IModifier;Lnet/minecraft/item/ItemStack;Lnet/minecraft/item/ItemStack;Lslimeknights/mantle/util/RecipeMatch$Match;)Z", false);
                        return;
                    }
                    case "apply": {
                        super.visitVarInsn(25, this.state);
                        super.visitMethodInsn(184, "xyz/phanta/tconevo/handler/ItemSensitiveModificationCoreHooks", "apply", "(Lslimeknights/tconstruct/library/modifiers/IModifier;Lnet/minecraft/item/ItemStack;Lslimeknights/mantle/util/RecipeMatch$Match;)V", false);
                        return;
                    }
                }
            }
            super.visitMethodInsn(opcode, owner, name, desc, itf);
        }
    }

    private static class ClassTransformerToolBuilder
    extends ClassVisitor {
        public ClassTransformerToolBuilder(int api, ClassVisitor cv) {
            super(api, cv);
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            switch (name) {
                case "tryModifyTool": 
                case "tryModifyArmor": {
                    return new MethodTransformerTryModifyTool(this.api, super.visitMethod(access, name, desc, signature, exceptions));
                }
                case "rebuildTool": {
                    return new MethodTransformerRebuildTool(this.api, super.visitMethod(access, name, desc, signature, exceptions));
                }
            }
            return super.visitMethod(access, name, desc, signature, exceptions);
        }
    }
}

