/*
 * Decompiled with CFR 0.152.
 */
package xyz.phanta.tconevo.coremod.util;

import io.github.phantamanta44.libnine.util.tuple.IPair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraftforge.fml.common.asm.transformers.deobf.FMLDeobfuscatingRemapper;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

@FunctionalInterface
public interface InsnMatcher {
    public static final InsnMatcher ANY_INSN = insn -> Collections.singleton(null);

    public Collection<InsnMatcher> step(AbstractInsnNode var1);

    public static InsnMatcher oneOf(InsnMatcher a, InsnMatcher b) {
        return insn -> {
            ArrayList<InsnMatcher> newStates = new ArrayList<InsnMatcher>();
            newStates.addAll(a.step(insn));
            newStates.addAll(b.step(insn));
            return newStates;
        };
    }

    public static InsnMatcher oneOf(InsnMatcher ... matchers) {
        return insn -> {
            ArrayList<InsnMatcher> newStates = new ArrayList<InsnMatcher>();
            for (InsnMatcher matcher : matchers) {
                newStates.addAll(matcher.step(insn));
            }
            return newStates;
        };
    }

    public static InsnMatcher oneOf(Iterable<InsnMatcher> matchers) {
        return insn -> {
            ArrayList<InsnMatcher> newStates = new ArrayList<InsnMatcher>();
            for (InsnMatcher matcher : matchers) {
                newStates.addAll(matcher.step(insn));
            }
            return newStates;
        };
    }

    default public InsnMatcher then(InsnMatcher next) {
        return insn -> {
            ArrayList<InsnMatcher> newStates = new ArrayList<InsnMatcher>();
            boolean accepted = false;
            for (InsnMatcher newState : this.step(insn)) {
                if (newState == null) {
                    accepted = true;
                    continue;
                }
                newStates.add(newState.then(next));
            }
            if (accepted) {
                newStates.add(next);
            }
            return newStates;
        };
    }

    public static InsnMatcher sequence(InsnMatcher head, InsnMatcher ... tail) {
        if (tail.length == 0) {
            return head;
        }
        InsnMatcher tailMatcher = tail[tail.length - 1];
        for (int i = tail.length - 2; i >= 0; --i) {
            tailMatcher = tail[i].then(tailMatcher);
        }
        return head.then(tailMatcher);
    }

    @Nullable
    default public Match match(@Nullable AbstractInsnNode start) {
        Collection<InsnMatcher> state = Collections.singleton(this);
        for (AbstractInsnNode insn = start; insn != null && !state.isEmpty(); insn = insn.getNext()) {
            ArrayList<InsnMatcher> nextState = new ArrayList<InsnMatcher>();
            for (InsnMatcher matcher : state) {
                for (InsnMatcher nextMatcher : matcher.step(insn)) {
                    if (nextMatcher == null) {
                        return new Match(start, insn.getNext());
                    }
                    nextState.add(nextMatcher);
                }
            }
            state = nextState;
        }
        return null;
    }

    @Nullable
    default public Match find(@Nullable AbstractInsnNode insns) {
        ArrayList<IPair> state = new ArrayList<IPair>();
        while (insns != null) {
            state.add(IPair.of((Object)insns, (Object)this));
            ArrayList<IPair> nextState = new ArrayList<IPair>();
            for (IPair partial : state) {
                for (InsnMatcher nextMatcher : ((InsnMatcher)partial.getB()).step(insns)) {
                    if (nextMatcher == null) {
                        return new Match((AbstractInsnNode)partial.getA(), insns.getNext());
                    }
                    nextState.add(IPair.of((Object)partial.getA(), (Object)nextMatcher));
                }
            }
            state = nextState;
            insns = insns.getNext();
        }
        return null;
    }

    public static InsnMatcher anyInsn(int opcode) {
        return insn -> insn.getOpcode() == opcode ? Collections.singleton(null) : Collections.emptyList();
    }

    public static <T extends AbstractInsnNode> InsnMatcher matchByType(Class<T> insnType, int opcode, Predicate<T> matcher) {
        return insn -> insn.getOpcode() == opcode && insnType.isInstance(insn) && matcher.test(insnType.cast(insn)) ? Collections.singleton(null) : Collections.emptyList();
    }

    public static InsnMatcher varInsn(int opcode, int varIndex) {
        return InsnMatcher.matchByType(VarInsnNode.class, opcode, insn -> insn.var == varIndex);
    }

    public static InsnMatcher fieldInsn(int opcode, String owner, String name, String desc) {
        String mappedName = FMLDeobfuscatingRemapper.INSTANCE.mapFieldName(owner, name, desc);
        return InsnMatcher.matchByType(FieldInsnNode.class, opcode, insn -> insn.owner.equals(owner) && insn.name.equals(mappedName) && insn.desc.equals(desc));
    }

    public static InsnMatcher methodInsn(int opcode, String owner, String name, String desc) {
        String mappedName = FMLDeobfuscatingRemapper.INSTANCE.mapMethodName(owner, name, desc);
        return InsnMatcher.matchByType(MethodInsnNode.class, opcode, insn -> insn.owner.equals(owner) && insn.name.equals(mappedName) && insn.desc.equals(desc));
    }

    public static InsnMatcher typeInsn(int opcode, String typeName) {
        return InsnMatcher.matchByType(TypeInsnNode.class, opcode, insn -> insn.desc.equals(typeName));
    }

    public static InsnMatcher intInsn(int opcode, int operand) {
        return InsnMatcher.matchByType(IntInsnNode.class, opcode, insn -> insn.operand == operand);
    }

    public static class Match {
        public final AbstractInsnNode start;
        @Nullable
        public final AbstractInsnNode tail;

        public Match(AbstractInsnNode start, @Nullable AbstractInsnNode tail) {
            this.start = start;
            this.tail = tail;
        }
    }
}

