/*
 * Decompiled with CFR 0.152.
 */
package xyz.phanta.tconevo.coremod.util;

import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraftforge.fml.common.asm.transformers.deobf.FMLDeobfuscatingRemapper;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;

public class SafeClassWriter
extends ClassWriter {
    private final ClassLoader resourceLoader;
    private static final Map<String, ClassTreeNode> classTreeCache = new HashMap<String, ClassTreeNode>();

    public SafeClassWriter(ClassReader reader, int flags, ClassLoader resourceLoader) {
        super(reader, flags);
        this.resourceLoader = resourceLoader;
    }

    protected String getCommonSuperClass(String type1, String type2) {
        if (type1.equals(type2)) {
            return type1;
        }
        try {
            return SafeClassWriter.meet(SafeClassWriter.resolve(type1, this.resourceLoader), SafeClassWriter.resolve(type2, this.resourceLoader));
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private static ClassTreeNode resolve(String className, ClassLoader loader) throws ClassNotFoundException {
        ClassTreeNode node = classTreeCache.get(className);
        if (node != null) {
            return node;
        }
        if (className.startsWith("java")) {
            node = SafeClassWriter.fromLoadedClass(Class.forName(className.replace('/', '.')));
            classTreeCache.put(className, node);
            return node;
        }
        URL classResource = loader.getResource(className + ".class");
        if (classResource == null) {
            String altName = FMLDeobfuscatingRemapper.INSTANCE.unmap(className);
            if (altName.equals(className)) {
                throw new ClassNotFoundException("Could not find class binary: " + className);
            }
            classResource = loader.getResource(altName + ".class");
            if (classResource == null) {
                throw new ClassNotFoundException("Could not find class binary: " + className + " (" + altName + ")");
            }
        }
        ClassTreeNodeFactory factory = new ClassTreeNodeFactory(className, loader);
        try (InputStream classStream = classResource.openStream();){
            new ClassReader(classStream).accept((ClassVisitor)factory, 7);
        }
        catch (Exception e) {
            throw new ClassNotFoundException("Failed to read class binary: " + className, e);
        }
        node = factory.getTreeNode();
        classTreeCache.put(className, node);
        return node;
    }

    private static ClassTreeNode fromLoadedClass(Class<?> clazz) {
        Class<?> superClass = clazz.getSuperclass();
        return new ClassTreeNode(clazz.getName().replace('.', '/'), superClass == null ? null : () -> SafeClassWriter.fromLoadedClass(superClass));
    }

    private static String meet(ClassTreeNode a, ClassTreeNode b) throws ClassNotFoundException {
        boolean progress;
        HashSet<String> aParents = new HashSet<String>();
        HashSet<String> bParents = new HashSet<String>();
        do {
            progress = false;
            if (a != null) {
                if (bParents.contains(a.className)) {
                    return a.className;
                }
                aParents.add(a.className);
                a = a.getSuper();
                progress = true;
            }
            if (b == null) continue;
            if (aParents.contains(b.className)) {
                return b.className;
            }
            bParents.add(b.className);
            b = b.getSuper();
            progress = true;
        } while (progress);
        return "java/lang/Object";
    }

    private static class ClassTreeNodeFactory
    extends ClassVisitor {
        private final String className;
        private final ClassLoader loader;
        @Nullable
        private ClassTreeNode result;

        ClassTreeNodeFactory(String className, ClassLoader loader) {
            super(327680);
            this.className = className;
            this.loader = loader;
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            String deobfSuperName = FMLDeobfuscatingRemapper.INSTANCE.map(superName);
            this.result = new ClassTreeNode(this.className, () -> SafeClassWriter.resolve(deobfSuperName, this.loader));
        }

        ClassTreeNode getTreeNode() {
            if (this.result == null) {
                throw new IllegalStateException("Did not receive class header data!");
            }
            return this.result;
        }
    }

    private static class ClassTreeNode {
        final String className;
        @Nullable
        private final ClassResolver superResolver;
        @Nullable
        private ClassTreeNode superCache;

        ClassTreeNode(String className, @Nullable ClassResolver superResolver) {
            this.className = className;
            this.superResolver = superResolver;
        }

        @Nullable
        ClassTreeNode getSuper() throws ClassNotFoundException {
            if (this.superResolver == null) {
                return null;
            }
            if (this.superCache == null) {
                this.superCache = this.superResolver.resolve();
            }
            return this.superCache;
        }
    }

    @FunctionalInterface
    private static interface ClassResolver {
        public ClassTreeNode resolve() throws ClassNotFoundException;
    }
}

