/*
 * Decompiled with CFR 0.152.
 */
package xyz.phanta.tconevo.handler;

import io.github.phantamanta44.libnine.util.math.MathUtils;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.conditions.RandomChance;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import xyz.phanta.tconevo.TconEvoConfig;
import xyz.phanta.tconevo.TconEvoMod;

public class ArtifactLootHandler {
    @Nullable
    private static Map<ResourceLocation, Double> lootProbabilities = null;

    private static Map<ResourceLocation, Double> getLootProbabilities() {
        if (lootProbabilities == null) {
            lootProbabilities = new HashMap<ResourceLocation, Double>();
            for (String entry : TconEvoConfig.artifacts.lootProbabilities) {
                int delim = entry.indexOf(44);
                if (delim == -1) {
                    TconEvoMod.LOGGER.warn("Bad loot probability entry (no comma): {}", (Object)entry);
                    continue;
                }
                try {
                    lootProbabilities.put(new ResourceLocation(entry.substring(0, delim)), Double.parseDouble(entry.substring(delim + 1)));
                }
                catch (Exception e) {
                    TconEvoMod.LOGGER.warn("Bad loot probability entry (excepted): " + entry, (Throwable)e);
                }
            }
        }
        return lootProbabilities;
    }

    @SubscribeEvent
    public void onLootTableLoaded(LootTableLoadEvent event) {
        Double oddsNullable;
        if (TconEvoConfig.artifacts.enabled && (oddsNullable = ArtifactLootHandler.getLootProbabilities().get(event.getName())) != null) {
            float odds = (float)MathUtils.clamp((double)oddsNullable, (double)0.0, (double)1.0);
            LootEntry[] artifacts = TconEvoMod.PROXY.getArtifactRegistry().getAllArtifacts().toArray(new LootEntry[0]);
            event.getTable().addPool(new LootPool(artifacts, new LootCondition[]{new RandomChance(odds)}, new RandomValueRange(1.0f), new RandomValueRange(0.0f), "tconevo_artifacts"));
        }
    }
}

