/*
 * Decompiled with CFR 0.152.
 */
package xyz.phanta.tconevo.handler;

import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.potion.Potion;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.events.MaterialEvent;
import slimeknights.tconstruct.library.materials.IMaterialStats;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.library.smeltery.AlloyRecipe;
import slimeknights.tconstruct.library.smeltery.CastingRecipe;
import slimeknights.tconstruct.library.traits.ITrait;
import xyz.phanta.tconevo.TconEvoConfig;
import xyz.phanta.tconevo.TconEvoMod;
import xyz.phanta.tconevo.material.MaterialBuilder;
import xyz.phanta.tconevo.util.TconReflect;

@Mod.EventBusSubscriber(modid="tconevo")
public class MaterialOverrideHandler {
    private static final Map<String, String> overrideMatIds = new HashMap<String, String>();
    private static final Multimap<String, String> overrideMatIdsInv = Multimaps.newMultimap(new HashMap(), ArrayList::new);
    private static final Multimap<String, OverriddenMaterial> overriddenMats = Multimaps.newMultimap(new HashMap(), ArrayList::new);
    private static final Map<Material, OverriddenMaterial> overriddenWrapperMap = new IdentityHashMap<Material, OverriddenMaterial>();

    public static void registerOverrides(String materialId, String ... overrideIds) {
        for (String overrideId : overrideIds) {
            overrideId = overrideId.toLowerCase();
            overrideMatIds.put(overrideId, materialId);
        }
    }

    public static Collection<String> getOverriddenIds(String materialId) {
        Set<String> ids = overrideMatIdsInv.get((Object)materialId);
        return ids != null ? ids : Collections.emptySet();
    }

    public static void override(String overrideMatId, Material overriddenMat) {
        OverriddenMaterial wrapper = new OverriddenMaterial(overriddenMat);
        overriddenMats.put((Object)overrideMatId, (Object)wrapper);
        overriddenWrapperMap.put(overriddenMat, wrapper);
    }

    public static void putOverriddenTrait(Material overriddenMat, @Nullable String partType, ITrait trait) {
        OverriddenMaterial wrapper;
        if (partType != null && (wrapper = overriddenWrapperMap.get(overriddenMat)) != null) {
            wrapper.traits.put((Object)partType, (Object)trait);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onMaterialRegistration(MaterialEvent.MaterialRegisterEvent event) {
        String overrideMatId;
        if (TconEvoConfig.overrideMaterials && (overrideMatId = overrideMatIds.get(event.material.identifier)) != null && MaterialBuilder.isNotBlacklisted(overrideMatId)) {
            ModContainer owningMod = Loader.instance().activeModContainer();
            TconEvoMod.LOGGER.info("Blocking registration of material {} registered by {}", (Object)event.material.identifier, (Object)(owningMod != null ? owningMod.getModId() : "unknown"));
            event.setCanceled(true);
            MaterialOverrideHandler.override(overrideMatId, event.material);
        }
    }

    @SubscribeEvent
    public static void onRegisterPotions(RegistryEvent.Register<Potion> event) {
        MaterialOverrideHandler.handleStatInheritance();
    }

    public static void handleStatInheritance() {
        overriddenMats.asMap().forEach((overrideMatId, inheritFrom) -> {
            Material overrideMat = TinkerRegistry.getMaterial((String)overrideMatId);
            if (overrideMat != Material.UNKNOWN) {
                for (OverriddenMaterial overriddenMat : inheritFrom) {
                    for (IMaterialStats statsObj : overriddenMat.material.getAllStats()) {
                        String statKey = statsObj.getIdentifier();
                        if (overrideMat.getStats(statKey) != null) continue;
                        ModContainer oldOwner = TconReflect.getStatOwnerMod(overriddenMat.material, statKey);
                        TinkerRegistry.addMaterialStats((Material)overrideMat, (IMaterialStats)statsObj);
                        if (oldOwner == null) continue;
                        TconReflect.overrideStatOwnerMod(overrideMat, statKey, oldOwner);
                    }
                }
            }
        });
    }

    public static void handleTraitInheritance() {
        overriddenMats.asMap().forEach((overrideMatId, inheritFrom) -> {
            Material overrideMat = TinkerRegistry.getMaterial((String)overrideMatId);
            if (overrideMat != Material.UNKNOWN) {
                for (OverriddenMaterial overriddenMat : inheritFrom) {
                    Map<String, List<ITrait>> overrideMatTraits = TconReflect.getTraits(overrideMat);
                    overriddenMat.traits.forEach((partType, trait) -> {
                        if (!overrideMatTraits.containsKey(partType)) {
                            ModContainer oldOwner = TconReflect.getTraitOwnerMod(overriddenMat.material, trait);
                            overrideMat.addTrait(trait, partType);
                            if (oldOwner != null) {
                                TconReflect.overrideTraitOwnerMod(overrideMat, trait, oldOwner);
                            }
                        }
                    });
                }
            }
        });
    }

    public static void handleRecipeOverrides() {
        HashMap<String, String> fluidMatMap = new HashMap<String, String>();
        overriddenMats.forEach((overrideMatId, overriddenMat) -> {
            if (overriddenMat.material.hasFluid()) {
                fluidMatMap.put(overriddenMat.material.getFluid().getName(), (String)overrideMatId);
            }
        });
        MaterialOverrideHandler.removeOverriddenFluidRecipes(fluidMatMap, TconReflect.iterateMeltingRecipes(), null, r -> r.output);
        MaterialOverrideHandler.removeOverriddenFluidRecipes(fluidMatMap, TconReflect.iterateTableCastRecipes(), r -> r instanceof CastingRecipe, r -> ((CastingRecipe)r).getFluid());
        MaterialOverrideHandler.removeOverriddenFluidRecipes(fluidMatMap, TconReflect.iterateBasinCastRecipes(), r -> r instanceof CastingRecipe, r -> ((CastingRecipe)r).getFluid());
        ListIterator<AlloyRecipe> iterAlloyRecipes = TconReflect.iterateAlloyRecipes();
        while (iterAlloyRecipes.hasNext()) {
            AlloyRecipe recipe = iterAlloyRecipes.next();
            boolean changed = false;
            ArrayList<FluidStack> newInputs = new ArrayList<FluidStack>();
            for (FluidStack input : recipe.getFluids()) {
                FluidStack overrideFluid = MaterialOverrideHandler.mapFluidByOverride(fluidMatMap, input);
                if (overrideFluid != null) {
                    newInputs.add(overrideFluid);
                    changed = true;
                    continue;
                }
                newInputs.add(input);
            }
            FluidStack result = recipe.getResult();
            FluidStack resultOverrideFluid = MaterialOverrideHandler.mapFluidByOverride(fluidMatMap, result);
            if (resultOverrideFluid != null) {
                result = resultOverrideFluid;
                changed = true;
            }
            if (!changed) continue;
            iterAlloyRecipes.set(new AlloyRecipe(result, newInputs.toArray(new FluidStack[0])));
        }
    }

    private static <T> void removeOverriddenFluidRecipes(Map<String, String> fluidMatMap, Iterator<T> iterRecipes, @Nullable Predicate<T> recipeFilter, Function<T, FluidStack> getFluid) {
        while (iterRecipes.hasNext()) {
            FluidStack overriddenFluid;
            FluidStack overrideFluid;
            T recipe = iterRecipes.next();
            if (recipeFilter != null && !recipeFilter.test(recipe) || (overrideFluid = MaterialOverrideHandler.mapFluidByOverride(fluidMatMap, overriddenFluid = getFluid.apply(recipe))) == null || overrideFluid.isFluidEqual(overriddenFluid)) continue;
            iterRecipes.remove();
        }
    }

    @Nullable
    private static FluidStack mapFluidByOverride(Map<String, String> fluidMatMap, FluidStack fluid) {
        Fluid newFluid;
        String oldFluidId = fluid.getFluid().getName();
        Material mat = TinkerRegistry.getMaterial((String)fluidMatMap.get(oldFluidId));
        if (mat != Material.UNKNOWN && mat.hasFluid() && !(newFluid = mat.getFluid()).getName().equals(oldFluidId)) {
            return new FluidStack(newFluid, fluid.amount);
        }
        return null;
    }

    static {
        MaterialOverrideHandler.registerOverrides("rubber", "integrationforegoing.plastic");
        MaterialOverrideHandler.registerOverrides("pink_slime", "integrationforegoing.pink_slime");
        MaterialOverrideHandler.registerOverrides("pink_metal", "integrationforegoing.reinforced_pink_slime");
        MaterialOverrideHandler.registerOverrides("black_quartz", "blackquartz_plustic");
        MaterialOverrideHandler.registerOverrides("void_crystal", "void_actadd_plustic");
        MaterialOverrideHandler.registerOverrides("enori_crystal", "enori_actadd_plustic");
        MaterialOverrideHandler.registerOverrides("palis_crystal", "palis_actadd_plustic");
        MaterialOverrideHandler.registerOverrides("restonia_crystal", "restonia_actadd_plustic");
        MaterialOverrideHandler.registerOverrides("emeraldic_crystal", "emeradic_actadd_plustic");
        MaterialOverrideHandler.registerOverrides("diamantine_crystal", "diamatine_actadd_plustic");
        MaterialOverrideHandler.registerOverrides("livingwood", "livingwood_plustic");
        MaterialOverrideHandler.registerOverrides("refined_obsidian", "refinedObsidian");
        MaterialOverrideHandler.registerOverrides("refined_glowstone", "refinedGlowstone");
        MaterialOverrideHandler.registerOverrides("darkwood", "darkwood_plustic");
        MaterialOverrideHandler.registerOverrides("ghostwood", "ghostwood_plustic");
        MaterialOverrideHandler.registerOverrides("fusewood", "fusewood_plustic");
        MaterialOverrideHandler.registerOverrides("bloodwood", "bloodwood_plustic");
        MaterialOverrideHandler.registerOverrides("wyvern_metal", "wyvern_plustic");
        MaterialOverrideHandler.registerOverrides("draconic_metal", "awakened_plustic");
        MaterialOverrideHandler.registerOverrides("chaotic_metal", "chaotic_plustic");
        MaterialOverrideHandler.registerOverrides("lumium", "lumium_plustic");
        MaterialOverrideHandler.registerOverrides("signalum", "signalum_plustic");
        MaterialOverrideHandler.registerOverrides("platinum", "platinum_plustic");
        MaterialOverrideHandler.registerOverrides("enderium", "enderium_plustic");
        MaterialOverrideHandler.registerOverrides("certus_quartz", "certusQuartz_plustic");
        MaterialOverrideHandler.registerOverrides("fluix", "fluixCrystal_plustic");
        MaterialOverrideHandler.registerOverrides("dark_matter", "darkMatter");
        MaterialOverrideHandler.registerOverrides("red_matter", "redMatter");
        MaterialOverrideHandler.registerOverrides("infinity_metal", "infinity_avaritia_plustic");
        MaterialOverrideHandler.registerOverrides("invar", "ref_invar");
        MaterialOverrideHandler.registerOverrides("aluminium", "ref_aluminum");
        MaterialOverrideHandler.registerOverrides("iridium", "ref_iridium");
        MaterialOverrideHandler.registerOverrides("platinum", "ref_platinum");
        MaterialOverrideHandler.registerOverrides("black_quartz", "ref_blackquartz");
        MaterialOverrideHandler.registerOverrides("diamantine_crystal", "ref_diamatine");
        MaterialOverrideHandler.registerOverrides("emeraldic_crystal", "ref_emeradic");
        MaterialOverrideHandler.registerOverrides("enori_crystal", "ref_enori");
        MaterialOverrideHandler.registerOverrides("palis_crystal", "ref_palis");
        MaterialOverrideHandler.registerOverrides("restonia_crystal", "ref_restonia");
        MaterialOverrideHandler.registerOverrides("void_crystal", "ref_void");
        MaterialOverrideHandler.registerOverrides("certus_quartz", "ref_certus_quartz");
        MaterialOverrideHandler.registerOverrides("fluix", "ref_fluid_crystal");
        MaterialOverrideHandler.registerOverrides("starmetal", "ref_starmetal");
        MaterialOverrideHandler.registerOverrides("dragonstone", "ref_dragonstone");
        MaterialOverrideHandler.registerOverrides("dreamwood", "ref_dreamwood");
        MaterialOverrideHandler.registerOverrides("elementium", "ref_elementium");
        MaterialOverrideHandler.registerOverrides("mana_string", "ref_mana_string");
        MaterialOverrideHandler.registerOverrides("manasteel", "ref_manasteel");
        MaterialOverrideHandler.registerOverrides("terrasteel", "ref_terrasteel");
        MaterialOverrideHandler.registerOverrides("mana_diamond", "ref_mana_diamond");
        MaterialOverrideHandler.registerOverrides("livingrock", "ref_livingrock");
        MaterialOverrideHandler.registerOverrides("livingwood", "ref_livingwood");
        MaterialOverrideHandler.registerOverrides("aquamarine", "ref_aquamarine");
        MaterialOverrideHandler.registerOverrides("osmium", "ref_osmium");
        MaterialOverrideHandler.registerOverrides("refined_obsidian", "ref_refined_obsidian");
        MaterialOverrideHandler.registerOverrides("refined_glowstone", "ref_refined_glowstone");
        MaterialOverrideHandler.registerOverrides("thaumium", "ref_thaumium");
        MaterialOverrideHandler.registerOverrides("enderium", "ref_enderium");
        MaterialOverrideHandler.registerOverrides("lumium", "ref_lumium");
        MaterialOverrideHandler.registerOverrides("signalum", "ref_signalum");
        MaterialOverrideHandler.registerOverrides("aluminium", "aluminum");
        MaterialOverrideHandler.registerOverrides("neutronium", "cosmic_neutronium");
        MaterialOverrideHandler.registerOverrides("infinity_metal", "infinity");
    }

    private static class OverriddenMaterial {
        final Material material;
        final Multimap<String, ITrait> traits = Multimaps.newMultimap(new HashMap(), ArrayList::new);

        OverriddenMaterial(Material material) {
            this.material = material;
            TconReflect.getTraits(material).forEach((arg_0, arg_1) -> this.traits.putAll(arg_0, arg_1));
        }
    }
}

