/*
 * Decompiled with CFR 0.152.
 */
package xyz.phanta.tconevo.init;

import io.github.phantamanta44.libnine.InitMe;
import io.github.phantamanta44.libnine.potion.PotionUndispellable;
import io.github.phantamanta44.libnine.util.math.MathUtils;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.potion.Potion;
import net.minecraft.util.DamageSource;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;
import xyz.phanta.tconevo.TconEvoConfig;
import xyz.phanta.tconevo.potion.PotionDamageBoost;
import xyz.phanta.tconevo.potion.PotionDamageReduction;
import xyz.phanta.tconevo.potion.PotionHealReduction;
import xyz.phanta.tconevo.util.DamageUtils;

public class TconEvoPotions {
    public static final String PREFIX = "effect.tconevo.";
    public static final Potion IMMORTALITY = new PotionUndispellable(false, 15450243).func_188413_j().func_76390_b("effect.tconevo.immortality");
    public static final Potion MORTAL_WOUNDS = new PotionHealReduction();
    public static final Potion DAMAGE_REDUCTION = new PotionDamageReduction();
    public static final Potion DAMAGE_BOOST = new PotionDamageBoost();

    @InitMe
    public static void init() {
        MinecraftForge.EVENT_BUS.register((Object)new TconEvoPotions());
    }

    @SubscribeEvent
    public void onRegisterPotions(RegistryEvent.Register<Potion> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])new Potion[]{(Potion)IMMORTALITY.setRegistryName("tconevo", "immortality"), (Potion)MORTAL_WOUNDS.setRegistryName("tconevo", "mortal_wounds"), (Potion)DAMAGE_REDUCTION.setRegistryName("tconevo", "damage_reduction"), (Potion)DAMAGE_BOOST.setRegistryName("tconevo", "damage_boost")});
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onEntityHurt(LivingDamageEvent event) {
        DamageSource dmgSrc = event.getSource();
        float amount = event.getAmount();
        if (amount <= 0.0f || DamageUtils.isPureDamage(dmgSrc, amount)) {
            return;
        }
        EntityLivingBase entity = event.getEntityLiving();
        if (entity.func_70660_b(IMMORTALITY) != null) {
            amount = MathUtils.clamp((float)(entity.func_110143_aJ() - (float)TconEvoConfig.general.effectImmortalityMinHealth), (float)0.0f, (float)amount);
        }
        event.setAmount(amount);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onEntityDeath(LivingDeathEvent event) {
        if (event.getSource() == DamageSource.field_76380_i) {
            return;
        }
        EntityLivingBase entity = event.getEntityLiving();
        if (entity.func_70660_b(IMMORTALITY) != null) {
            entity.func_70606_j((float)TconEvoConfig.general.effectImmortalityMinHealth);
            entity.field_70172_ad = entity.field_70771_an;
            entity.func_184589_d(IMMORTALITY);
            event.setCanceled(true);
        }
    }
}

