/*
 * Decompiled with CFR 0.152.
 */
package xyz.phanta.tconevo.integration.astralsorcery;

import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import xyz.phanta.tconevo.integration.IntegrationHooks;
import xyz.phanta.tconevo.integration.astralsorcery.AstralConstellation;
import xyz.phanta.tconevo.integration.naturalpledge.NaturalPledgeHooks;

public interface AstralHooks
extends IntegrationHooks {
    public static final String MOD_ID = "astralsorcery";
    @IntegrationHooks.Inject(value="astralsorcery", sided=true)
    public static final AstralHooks INSTANCE = new Noop();

    public boolean isConstellationInSky(World var1, AstralConstellation var2);

    @Nullable
    public AstralConstellation resolveConstellation(Object var1);

    public void freezeTime(World var1, BlockPos var2, Entity var3, float var4, int var5, boolean var6);

    public void spawnFlare(EntityPlayer var1, EntityLivingBase var2);

    default public void drawMineralisArmourEffect(EntityPlayer player) {
    }

    public static class Noop
    implements AstralHooks {
        @Override
        public boolean isConstellationInSky(World world, AstralConstellation constellation) {
            return world.field_73011_w.func_76569_d() && !world.func_72935_r();
        }

        @Override
        @Nullable
        public AstralConstellation resolveConstellation(Object constellation) {
            return null;
        }

        @Override
        public void freezeTime(World world, BlockPos pos, Entity attacker, float range, int duration, boolean reducedParticles) {
            for (Entity entity : world.func_175674_a(attacker, new AxisAlignedBB(pos).func_186662_g((double)range), null)) {
                if (!(entity instanceof EntityLivingBase)) continue;
                NaturalPledgeHooks.INSTANCE.applyRooted((EntityLivingBase)entity, duration);
            }
        }

        @Override
        public void spawnFlare(EntityPlayer owner, EntityLivingBase aggro) {
        }
    }
}

