/*
 * Decompiled with CFR 0.152.
 */
package xyz.phanta.tconevo.integration.bloodmagic;

import java.util.Optional;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import xyz.phanta.tconevo.integration.IntegrationHooks;
import xyz.phanta.tconevo.integration.bloodmagic.DemonWillType;

public interface BloodMagicHooks
extends IntegrationHooks {
    public static final String MOD_ID = "bloodmagic";
    @IntegrationHooks.Inject(value="bloodmagic")
    public static final BloodMagicHooks INSTANCE = new Noop();

    public Optional<ItemStack> getItemWeakBloodShard();

    public int extractLifePoints(EntityPlayer var1, int var2, ItemStack var3);

    public boolean isSoulDamage(DamageSource var1);

    public void handleDemonWillDrops(EntityLivingBase var1, EntityLivingBase var2, ItemStack var3);

    public DemonWillType getLargestWillType(EntityPlayer var1);

    public double getTotalDemonWill(EntityPlayer var1, DemonWillType var2);

    public double extractDemonWill(EntityPlayer var1, DemonWillType var2, double var3);

    public void applySoulSnare(EntityLivingBase var1, int var2);

    public int getSoulFrayLevel(EntityLivingBase var1);

    public static class Noop
    implements BloodMagicHooks {
        @Override
        public Optional<ItemStack> getItemWeakBloodShard() {
            return Optional.empty();
        }

        @Override
        public int extractLifePoints(EntityPlayer player, int amount, ItemStack consumer) {
            return 0;
        }

        @Override
        public boolean isSoulDamage(DamageSource dmgSrc) {
            return false;
        }

        @Override
        public void handleDemonWillDrops(EntityLivingBase attacker, EntityLivingBase target, ItemStack weapon) {
        }

        @Override
        public DemonWillType getLargestWillType(EntityPlayer player) {
            return DemonWillType.RAW;
        }

        @Override
        public double getTotalDemonWill(EntityPlayer player, DemonWillType type) {
            return 0.0;
        }

        @Override
        public double extractDemonWill(EntityPlayer player, DemonWillType type, double amount) {
            return 0.0;
        }

        @Override
        public void applySoulSnare(EntityLivingBase entity, int duration) {
        }

        @Override
        public int getSoulFrayLevel(EntityLivingBase entity) {
            return -1;
        }
    }
}

