/*
 * Decompiled with CFR 0.152.
 */
package xyz.phanta.tconevo.integration.bloodmagic;

import WayofTime.bloodmagic.api.impl.BloodMagicAPI;
import WayofTime.bloodmagic.api.impl.BloodMagicRecipeRegistrar;
import WayofTime.bloodmagic.core.RegistrarBloodMagic;
import WayofTime.bloodmagic.core.RegistrarBloodMagicItems;
import WayofTime.bloodmagic.core.data.SoulTicket;
import WayofTime.bloodmagic.item.soul.ItemSentientSword;
import WayofTime.bloodmagic.soul.EnumDemonWillType;
import WayofTime.bloodmagic.soul.IDemonWill;
import WayofTime.bloodmagic.soul.PlayerDemonWillHandler;
import WayofTime.bloodmagic.util.BooleanResult;
import WayofTime.bloodmagic.util.DamageSourceBloodMagic;
import WayofTime.bloodmagic.util.helper.NetworkHelper;
import io.github.phantamanta44.libnine.util.world.WorldUtils;
import java.util.List;
import java.util.Optional;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import xyz.phanta.tconevo.TconEvoConfig;
import xyz.phanta.tconevo.init.TconEvoItems;
import xyz.phanta.tconevo.integration.bloodmagic.BloodMagicHooks;
import xyz.phanta.tconevo.integration.bloodmagic.DemonWillType;
import xyz.phanta.tconevo.item.ItemMaterial;
import xyz.phanta.tconevo.item.ItemMetal;
import xyz.phanta.tconevo.trait.bloodmagic.TraitSentient;
import xyz.phanta.tconevo.util.ToolUtils;

public class BloodMagicHooksImpl
implements BloodMagicHooks {
    @Override
    public void onInit(FMLInitializationEvent event) {
        BloodMagicRecipeRegistrar recipes = BloodMagicAPI.INSTANCE.getRecipeRegistrar();
        recipes.addBloodAltar(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{ItemMaterial.Type.COALESCENCE_MATRIX.newStack(1)}), TconEvoItems.METAL.newStack(ItemMetal.Type.BOUND_METAL, ItemMetal.Form.INGOT, 1), 3, 30000, 50, 100);
        recipes.addTartaricForge(TconEvoItems.METAL.newStack(ItemMetal.Type.SENTIENT_METAL, ItemMetal.Form.INGOT, 1), 16.0, 6.0, new Object[]{new ItemStack(RegistrarBloodMagicItems.SOUL_GEM), ItemMaterial.Type.COALESCENCE_MATRIX.newStack(1)});
    }

    @Override
    public Optional<ItemStack> getItemWeakBloodShard() {
        if (RegistrarBloodMagicItems.BLOOD_SHARD == Items.field_190931_a) {
            return Optional.empty();
        }
        return Optional.of(new ItemStack(RegistrarBloodMagicItems.BLOOD_SHARD, 1, 0));
    }

    @Override
    public int extractLifePoints(EntityPlayer player, int amount, ItemStack consumer) {
        BooleanResult result = NetworkHelper.getSoulNetwork((EntityPlayer)player).syphonAndDamage(player, SoulTicket.item((ItemStack)consumer, (World)player.field_70170_p, (Entity)player, (int)amount));
        return result.isSuccess() ? (Integer)result.getValue() : 0;
    }

    @Override
    public boolean isSoulDamage(DamageSource dmgSrc) {
        return dmgSrc == DamageSourceBloodMagic.INSTANCE;
    }

    @Override
    public void handleDemonWillDrops(EntityLivingBase attacker, EntityLivingBase target, ItemStack weapon) {
        if (RegistrarBloodMagicItems.SENTIENT_SWORD == Items.field_190931_a) {
            return;
        }
        ItemSentientSword itemSword = (ItemSentientSword)RegistrarBloodMagicItems.SENTIENT_SWORD;
        ItemStack dummyWeapon = new ItemStack((Item)itemSword);
        if (ToolUtils.hasTrait(weapon, "tconevo.sentient")) {
            TraitSentient.WillPower willPower = TraitSentient.getWillPower(weapon);
            itemSword.setCurrentType(dummyWeapon, BloodMagicHooksImpl.unwrap(willPower.getWillType()));
            itemSword.setStaticDropOfActivatedSword(dummyWeapon, willPower.getStaticDropRate());
            itemSword.setDropOfActivatedSword(dummyWeapon, willPower.getBonusDropRate());
        } else {
            itemSword.setStaticDropOfActivatedSword(dummyWeapon, TconEvoConfig.moduleBloodMagic.willfulStaticDropBase);
            itemSword.setDropOfActivatedSword(dummyWeapon, TconEvoConfig.moduleBloodMagic.willfulBonusDropBase);
        }
        List drops = itemSword.getRandomDemonWillDrop(target, attacker, dummyWeapon, 0);
        if (drops.isEmpty()) {
            return;
        }
        Vec3d targetPos = target.func_174791_d();
        for (ItemStack stack : drops) {
            IDemonWill willItem;
            if (attacker instanceof EntityPlayer) {
                stack = PlayerDemonWillHandler.addDemonWill((EntityPlayer)((EntityPlayer)attacker), (ItemStack)stack);
            }
            if (stack.func_190926_b() || !((willItem = (IDemonWill)stack.func_77973_b()).getWill(willItem.getType(stack), stack) >= 1.0E-4)) continue;
            WorldUtils.dropItem((World)target.field_70170_p, (Vec3d)targetPos, (ItemStack)stack);
        }
        if (attacker instanceof EntityPlayer) {
            ((EntityPlayer)attacker).field_71069_bz.func_75142_b();
        }
    }

    @Override
    public DemonWillType getLargestWillType(EntityPlayer player) {
        return BloodMagicHooksImpl.wrap(PlayerDemonWillHandler.getLargestWillType((EntityPlayer)player));
    }

    @Override
    public double getTotalDemonWill(EntityPlayer player, DemonWillType type) {
        return PlayerDemonWillHandler.getTotalDemonWill((EnumDemonWillType)BloodMagicHooksImpl.unwrap(type), (EntityPlayer)player);
    }

    @Override
    public double extractDemonWill(EntityPlayer player, DemonWillType type, double amount) {
        return PlayerDemonWillHandler.consumeDemonWill((EnumDemonWillType)BloodMagicHooksImpl.unwrap(type), (EntityPlayer)player, (double)amount);
    }

    @Override
    public void applySoulSnare(EntityLivingBase entity, int duration) {
        entity.func_70690_d(new PotionEffect(RegistrarBloodMagic.SOUL_SNARE, duration, 0));
    }

    @Override
    public int getSoulFrayLevel(EntityLivingBase entity) {
        PotionEffect effect = entity.func_70660_b(RegistrarBloodMagic.SOUL_FRAY);
        return effect != null ? effect.func_76458_c() : -1;
    }

    private static EnumDemonWillType unwrap(DemonWillType type) {
        switch (type) {
            case RAW: {
                return EnumDemonWillType.DEFAULT;
            }
            case CORROSIVE: {
                return EnumDemonWillType.CORROSIVE;
            }
            case DESTRUCTIVE: {
                return EnumDemonWillType.DESTRUCTIVE;
            }
            case VENGEFUL: {
                return EnumDemonWillType.VENGEFUL;
            }
            case STEADFAST: {
                return EnumDemonWillType.STEADFAST;
            }
        }
        throw new IllegalArgumentException("Bad demon will type: " + (Object)((Object)type));
    }

    private static DemonWillType wrap(EnumDemonWillType type) {
        switch (type) {
            case DEFAULT: {
                return DemonWillType.RAW;
            }
            case CORROSIVE: {
                return DemonWillType.CORROSIVE;
            }
            case DESTRUCTIVE: {
                return DemonWillType.DESTRUCTIVE;
            }
            case VENGEFUL: {
                return DemonWillType.VENGEFUL;
            }
            case STEADFAST: {
                return DemonWillType.STEADFAST;
            }
        }
        throw new IllegalArgumentException("Bad demon will type: " + type);
    }
}

