/*
 * Decompiled with CFR 0.152.
 */
package xyz.phanta.tconevo.integration.conarm;

import c4.conarm.common.armor.utils.ArmorHelper;
import c4.conarm.integrations.tinkertoolleveling.ModArmorLeveling;
import c4.conarm.lib.ArmoryRegistry;
import c4.conarm.lib.armor.ArmorCore;
import c4.conarm.lib.events.ArmoryEvent;
import c4.conarm.lib.modifiers.ArmorModifierTrait;
import c4.conarm.lib.tinkering.ArmorBuilder;
import c4.conarm.lib.tinkering.TinkersArmor;
import c4.conarm.lib.utils.RecipeMatchHolder;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import slimeknights.tconstruct.library.events.TinkerCraftingEvent;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.library.modifiers.IModifier;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.TinkerGuiException;
import slimeknights.tconstruct.library.tinkering.PartMaterialType;
import slimeknights.tconstruct.library.tools.IToolPart;
import slimeknights.tconstruct.library.utils.TagUtil;
import slimeknights.tconstruct.tools.TinkerModifiers;
import xyz.phanta.tconevo.TconEvoConfig;
import xyz.phanta.tconevo.artifact.type.ArtifactType;
import xyz.phanta.tconevo.artifact.type.ArtifactTypeArmour;
import xyz.phanta.tconevo.artifact.type.ArtifactTypeTool;
import xyz.phanta.tconevo.init.TconEvoTraits;
import xyz.phanta.tconevo.integration.conarm.ConArmHooks;
import xyz.phanta.tconevo.integration.conarm.TconEvoArmourMaterials;
import xyz.phanta.tconevo.integration.conarm.TconEvoArmourTraits;
import xyz.phanta.tconevo.integration.conarm.material.ArmourMaterialDefinition;
import xyz.phanta.tconevo.integration.draconicevolution.DraconicHooks;
import xyz.phanta.tconevo.integration.gamestages.GameStagesHooks;
import xyz.phanta.tconevo.util.ToolUtils;

public class ConArmHooksImpl
implements ConArmHooks {
    private static final String TAG_EQ_SLOT = "ConArmEquipmentSlot";
    private static final EntityEquipmentSlot[] EQ_SLOTS = EntityEquipmentSlot.values();

    @Override
    public void onPreInit(FMLPreInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)this);
        TconEvoArmourMaterials.init();
    }

    @Override
    public void registerModifiers() {
        ArmourMaterialDefinition.initMaterialTraits();
        TconEvoArmourTraits.initModifierMaterials();
        DraconicHooks.INSTANCE.addUpgradeRecipes((Modifier)TconEvoArmourTraits.MOD_DRACONIC_ENERGY, "rfCap");
        DraconicHooks.INSTANCE.addUpgradeRecipes((Modifier)TconEvoArmourTraits.MOD_DRACONIC_SHIELD_CAPACITY, "shieldCap");
        DraconicHooks.INSTANCE.addUpgradeRecipes((Modifier)TconEvoArmourTraits.MOD_DRACONIC_SHIELD_RECOVERY, "shieldRec");
        DraconicHooks.INSTANCE.addUpgradeRecipes((Modifier)TconEvoArmourTraits.MOD_DRACONIC_MOVE_SPEED, "moveSpeed");
        DraconicHooks.INSTANCE.addUpgradeRecipes((Modifier)TconEvoArmourTraits.MOD_DRACONIC_JUMP_BOOST, "jumpBoost");
    }

    @Override
    public boolean isArmourModifierTrait(IModifier mod) {
        return mod instanceof ArmorModifierTrait;
    }

    @Override
    @Nullable
    public EntityEquipmentSlot getArmourType(NBTTagCompound rootTag) {
        if (!rootTag.func_74764_b(TAG_EQ_SLOT)) {
            return null;
        }
        int eqNdx = rootTag.func_74762_e(TAG_EQ_SLOT);
        return eqNdx < 0 || eqNdx >= EQ_SLOTS.length ? null : EQ_SLOTS[eqNdx];
    }

    @SubscribeEvent
    public void onArmourBuilt(ArmoryEvent.OnItemBuilding event) {
        event.tag.func_74768_a(TAG_EQ_SLOT, event.armor.field_77881_a.ordinal());
        if (ToolUtils.hasModifier(event.tag, "tconevo.evolved_armor")) {
            TconEvoArmourTraits.TRAIT_EVOLVED[0].initDraconicModifiers(event.tag, event.armor.field_77881_a);
        }
    }

    @Override
    public void rebuildArmour(NBTTagCompound rootTag, Item item) throws TinkerGuiException {
        ArmorBuilder.rebuildArmor((NBTTagCompound)rootTag, (TinkersArmor)((TinkersArmor)item));
    }

    @Override
    public boolean hasArmourModMatches(IModifier mod) {
        return RecipeMatchHolder.getRecipes((IModifier)mod).map(m -> !m.isEmpty()).orElse(false);
    }

    @Override
    public boolean isTinkerArmour(ItemStack stack) {
        return stack.func_77973_b() instanceof TinkersArmor;
    }

    @Override
    public void damageArmour(ItemStack stack, int amount, EntityLivingBase wearer) {
        if (wearer instanceof EntityPlayer) {
            ArmorHelper.damageArmor((ItemStack)stack, (DamageSource)DamageSource.field_76377_j, (int)amount, (EntityPlayer)((EntityPlayer)wearer));
        }
    }

    @Override
    public ItemStack buildArmourArtifact(ArtifactTypeArmour.Spec spec) throws ArtifactType.BuildingException {
        ArmorCore armourType = ArmoryRegistry.getArmor().stream().filter(t -> t.getIdentifier().equals(spec.armourType)).findAny().orElseThrow(() -> new ArtifactType.BuildingException("Unknown armour type \"%s\"", spec.armourType));
        List componentTypes = armourType.getRequiredComponents();
        if (spec.materials.size() != componentTypes.size()) {
            throw new ArtifactType.BuildingException("Needed %d materials but got %d for armour type \"%s\"", componentTypes.size(), spec.materials.size(), armourType.getIdentifier());
        }
        List<Material> materials = ArtifactTypeTool.resolveMaterials(spec.materials);
        NonNullList components = NonNullList.func_191196_a();
        for (int i = 0; i < materials.size(); ++i) {
            Set parts = ((PartMaterialType)componentTypes.get(i)).getPossibleParts();
            if (parts.isEmpty()) {
                throw new ArtifactType.BuildingException("Unsatisfiable part %d for armour type \"%s\"", i, armourType.getIdentifier());
            }
            components.add((Object)((IToolPart)parts.iterator().next()).getItemstackWithMaterial(materials.get(i)));
        }
        ItemStack stack = armourType.buildItem(materials);
        stack.func_151001_c(ArtifactType.ARTIFACT_FMT + spec.name);
        try {
            GameStagesHooks.INSTANCE.startBypass();
            TinkerCraftingEvent.ToolCraftingEvent.fireEvent((ItemStack)stack, null, (NonNullList)components);
        }
        catch (TinkerGuiException e) {
            throw new ArtifactType.BuildingException("Armour building produced error: %s", e.getMessage());
        }
        finally {
            GameStagesHooks.INSTANCE.endBypass();
        }
        ItemStack stackPreMods = stack.func_77946_l();
        if (TconEvoConfig.artifacts.freeModBaseline >= 0) {
            NBTTagCompound toolTag = TagUtil.getToolTag((ItemStack)stack);
            for (int i = toolTag.func_74762_e("FreeModifiers"); i < TconEvoConfig.artifacts.freeModBaseline; ++i) {
                TinkerModifiers.modCreative.apply(stack);
            }
        }
        for (int i = spec.freeMods; i > 0; --i) {
            TinkerModifiers.modCreative.apply(stack);
        }
        ArtifactTypeTool.applyModifiers(spec.modifiers, stack);
        try {
            GameStagesHooks.INSTANCE.startBypass();
            TinkerCraftingEvent.ToolModifyEvent.fireEvent((ItemStack)stack, null, (ItemStack)stackPreMods.func_77946_l());
            TconEvoTraits.MOD_ARTIFACT.apply(stack);
            NBTTagCompound tag = TagUtil.getTagSafe((ItemStack)stack);
            ArmorBuilder.rebuildArmor((NBTTagCompound)tag, (TinkersArmor)armourType);
            stack.func_77982_d(tag);
        }
        catch (TinkerGuiException e) {
            throw new ArtifactType.BuildingException("Armour modification produced error: %s", e.getMessage());
        }
        finally {
            GameStagesHooks.INSTANCE.endBypass();
        }
        ArtifactTypeTool.addExtraItemData(stack, spec.lore, spec.dataTag);
        return stack;
    }

    @Override
    public void addArmourXpFromDamage(ItemStack stack, float damage, EntityPlayer player) {
        if (ModArmorLeveling.modArmorLeveling != null) {
            ModArmorLeveling.modArmorLeveling.addXp(stack, MathHelper.func_76125_a((int)((int)(damage * ModArmorLeveling.damageToXP)), (int)1, (int)ModArmorLeveling.xpGainCap), player);
        }
    }

    @Override
    public Collection<? extends Item> getArmourItems() {
        return ArmoryRegistry.getArmor();
    }
}

