/*
 * Decompiled with CFR 0.152.
 */
package xyz.phanta.tconevo.integration.conarm.trait.astralsorcery;

import c4.conarm.common.armor.utils.ArmorHelper;
import c4.conarm.common.armor.utils.ArmorTagUtil;
import c4.conarm.lib.armor.ArmorModifications;
import c4.conarm.lib.armor.ArmorNBT;
import c4.conarm.lib.modifiers.ArmorModifierTrait;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import slimeknights.tconstruct.library.modifiers.ModifierAspect;
import slimeknights.tconstruct.library.utils.TagUtil;
import slimeknights.tconstruct.library.utils.ToolHelper;
import xyz.phanta.tconevo.TconEvoConfig;
import xyz.phanta.tconevo.integration.astralsorcery.AstralConstellation;
import xyz.phanta.tconevo.integration.astralsorcery.AstralHooks;
import xyz.phanta.tconevo.util.DamageUtils;

public abstract class ArmourModAttuned
extends ArmorModifierTrait {
    private final AstralConstellation constellation;

    public ArmourModAttuned(String identifier, AstralConstellation constellation) {
        super(identifier, 25337);
        this.constellation = constellation;
        this.aspects.remove(this.aspects.lastIndexOf(ModifierAspect.freeModifier));
    }

    public AstralConstellation getConstellation() {
        return this.constellation;
    }

    public void applyEffect(NBTTagCompound rootCompound, NBTTagCompound modifierTag) {
        super.applyEffect(rootCompound, modifierTag);
        rootCompound.func_74768_a("AttunedConstellation", this.constellation.ordinal());
    }

    public ArmorModifications getModifications(EntityPlayer player, ArmorModifications mods, ItemStack armour, DamageSource source, double damage, int slot) {
        if (this.isConstellationInSky(player.field_70170_p)) {
            mods.addEffectiveness((float)TconEvoConfig.moduleAstralSorcery.attunementBonusProtection);
        }
        return mods;
    }

    private boolean isConstellationInSky(World world) {
        return AstralHooks.INSTANCE.isConstellationInSky(world, this.constellation);
    }

    public static class Pelotrio
    extends ArmourModAttuned {
        public Pelotrio() {
            super("tconevo.attuned_pelotrio", AstralConstellation.PELOTRIO);
        }

        public void onArmorTick(ItemStack tool, World world, EntityPlayer player) {
            double odds;
            if (!world.field_72995_K && player.field_70173_aa % 20 == 0 && tool.func_77952_i() > 0 && !ToolHelper.isBroken((ItemStack)tool) && (odds = TconEvoConfig.moduleAstralSorcery.armourPelotrioRepairProbability) > 0.0 && (odds >= 1.0 || world.field_73012_v.nextDouble() <= odds)) {
                ArmorHelper.healArmor((ItemStack)tool, (int)1, (EntityPlayer)player, (int)EntityLiving.func_184640_d((ItemStack)tool).func_188454_b());
            }
        }
    }

    public static class Octans
    extends EffectPassivePotion {
        public Octans() {
            super("tconevo.attuned_octans", AstralConstellation.OCTANS);
        }

        @Override
        protected Potion getPotionType() {
            return MobEffects.field_76427_o;
        }
    }

    public static class Mineralis
    extends ArmourModAttuned {
        public Mineralis() {
            super("tconevo.attuned_mineralis", AstralConstellation.MINERALIS);
            MinecraftForge.EVENT_BUS.register((Object)this);
        }

        @SideOnly(value=Side.CLIENT)
        @SubscribeEvent
        public void onPlayerTick(TickEvent.PlayerTickEvent event) {
            if (event.phase == TickEvent.Phase.END) {
                for (ItemStack stack : event.player.field_71071_by.field_70460_b) {
                    if (!this.isToolWithTrait(stack)) continue;
                    AstralHooks.INSTANCE.drawMineralisArmourEffect(event.player);
                    break;
                }
            }
        }
    }

    public static class Lucerna
    extends EffectPassivePotion {
        public Lucerna() {
            super("tconevo.attuned_lucerna", AstralConstellation.LUCERNA);
        }

        @Override
        protected Potion getPotionType() {
            return MobEffects.field_76439_r;
        }

        @Override
        protected int getPotionDuration() {
            return 300;
        }
    }

    public static class Horologium
    extends EffectAfterHit {
        public Horologium() {
            super("tconevo.attuned_horologium", AstralConstellation.HOROLOGIUM);
        }

        @Override
        protected void doAttunedEffect(ItemStack armour, EntityPlayer player, @Nullable EntityLivingBase attacker, float damage) {
            if (!player.func_184811_cZ().func_185141_a(armour.func_77973_b())) {
                AstralHooks.INSTANCE.freezeTime(player.field_70170_p, player.func_180425_c(), (Entity)player, (float)TconEvoConfig.moduleAstralSorcery.armourHorologiumFreezeRange, TconEvoConfig.moduleAstralSorcery.armourHorologiumFreezeDuration, false);
                player.func_184811_cZ().func_185145_a(armour.func_77973_b(), TconEvoConfig.moduleAstralSorcery.armourHorologiumCooldown);
            }
        }
    }

    public static class Fornax
    extends EffectPassivePotion {
        public Fornax() {
            super("tconevo.attuned_fornax", AstralConstellation.FORNAX);
        }

        @Override
        protected Potion getPotionType() {
            return MobEffects.field_76426_n;
        }
    }

    public static class Bootes
    extends EffectAfterHit {
        public Bootes() {
            super("tconevo.attuned_bootes", AstralConstellation.BOOTES);
        }

        @Override
        protected void doAttunedEffect(ItemStack armour, EntityPlayer player, @Nullable EntityLivingBase attacker, float damage) {
            double odds;
            if (attacker != null && (odds = TconEvoConfig.moduleAstralSorcery.armourBootesFlareProbability) > 0.0 && (odds >= 1.0 || player.field_70170_p.field_73012_v.nextDouble() <= odds)) {
                AstralHooks.INSTANCE.spawnFlare(player, attacker);
            }
        }
    }

    public static class Vicio
    extends EffectAfterHit {
        public Vicio() {
            super("tconevo.attuned_vicio", AstralConstellation.VICIO);
        }

        @Override
        protected void doAttunedEffect(ItemStack armour, EntityPlayer player, @Nullable EntityLivingBase attacker, float damage) {
            player.func_70690_d(new PotionEffect(MobEffects.field_76424_c, TconEvoConfig.moduleAstralSorcery.armourVicioSpeedDuration, 1));
        }
    }

    public static class Evorsio
    extends EffectPassivePotion {
        public Evorsio() {
            super("tconevo.attuned_evorsio", AstralConstellation.EVORSIO);
        }

        @Override
        protected Potion getPotionType() {
            return MobEffects.field_76422_e;
        }
    }

    public static class Discidia
    extends EffectAfterHit {
        public Discidia() {
            super("tconevo.attuned_discidia", AstralConstellation.DISCIDIA);
        }

        @Override
        protected void doAttunedEffect(ItemStack armour, EntityPlayer player, @Nullable EntityLivingBase attacker, float damage) {
            if (attacker != null && (damage *= (float)TconEvoConfig.moduleAstralSorcery.armourDiscidiaReflectRatio) > 0.0f) {
                DamageUtils.attackEntityWithTool((EntityLivingBase)player, armour, (Entity)attacker, DamageSource.func_92087_a((Entity)player), damage);
            }
        }
    }

    public static class Armara
    extends ArmourModAttuned {
        public Armara() {
            super("tconevo.attuned_armara", AstralConstellation.ARMARA);
        }

        @Override
        public void applyEffect(NBTTagCompound rootCompound, NBTTagCompound modifierTag) {
            super.applyEffect(rootCompound, modifierTag);
            float bonusProt = (float)TconEvoConfig.moduleAstralSorcery.armourArmaraBonusProtection;
            if (bonusProt > 0.0f) {
                ArmorNBT armourData = ArmorTagUtil.getArmorStats((NBTTagCompound)rootCompound);
                ArmorNBT origData = ArmorTagUtil.getOriginalArmorStats((NBTTagCompound)rootCompound);
                armourData.defense += origData.defense * bonusProt;
                armourData.toughness += origData.toughness * bonusProt;
                TagUtil.setToolTag((NBTTagCompound)rootCompound, (NBTTagCompound)armourData.get());
            }
        }
    }

    public static class Aevitas
    extends EffectAfterHit {
        public Aevitas() {
            super("tconevo.attuned_aevitas", AstralConstellation.AEVITAS);
        }

        @Override
        protected void doAttunedEffect(ItemStack armour, EntityPlayer player, @Nullable EntityLivingBase attacker, float damage) {
            player.func_70690_d(new PotionEffect(MobEffects.field_76428_l, TconEvoConfig.moduleAstralSorcery.armourAevitasRegenDuration, 1));
        }
    }

    private static abstract class EffectPassivePotion
    extends ArmourModAttuned {
        EffectPassivePotion(String identifier, AstralConstellation constellation) {
            super(identifier, constellation);
            MinecraftForge.EVENT_BUS.register((Object)this);
        }

        @SubscribeEvent
        public void onPlayerTick(TickEvent.PlayerTickEvent event) {
            if (!event.player.field_70170_p.field_72995_K && event.phase == TickEvent.Phase.START && event.player.field_70173_aa % 40 == 0) {
                for (ItemStack stack : event.player.field_71071_by.field_70460_b) {
                    if (!this.isToolWithTrait(stack)) continue;
                    event.player.func_70690_d(new PotionEffect(this.getPotionType(), this.getPotionDuration(), 0, false, false));
                    break;
                }
            }
        }

        protected abstract Potion getPotionType();

        protected int getPotionDuration() {
            return 60;
        }
    }

    private static abstract class EffectAfterHit
    extends ArmourModAttuned {
        EffectAfterHit(String identifier, AstralConstellation constellation) {
            super(identifier, constellation);
        }

        public float onHurt(ItemStack armour, EntityPlayer player, DamageSource source, float damage, float newDamage, LivingHurtEvent event) {
            if (!player.field_70170_p.field_72995_K) {
                Entity attacker = event.getSource().func_76346_g();
                this.doAttunedEffect(armour, player, attacker instanceof EntityLivingBase ? (EntityLivingBase)attacker : null, newDamage);
            }
            return newDamage;
        }

        protected abstract void doAttunedEffect(ItemStack var1, EntityPlayer var2, @Nullable EntityLivingBase var3, float var4);
    }
}

