/*
 * Decompiled with CFR 0.152.
 */
package xyz.phanta.tconevo.integration.conarm.trait.base;

import c4.conarm.lib.traits.AbstractArmorTrait;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.library.modifiers.IModifier;
import slimeknights.tconstruct.library.modifiers.ModifierAspect;
import slimeknights.tconstruct.library.modifiers.ModifierNBT;
import slimeknights.tconstruct.library.utils.TinkerUtil;
import xyz.phanta.tconevo.trait.base.IncrementalModifier;
import xyz.phanta.tconevo.trait.base.StackableTrait;
import xyz.phanta.tconevo.util.ToolUtils;

public abstract class StackableArmourTrait
extends AbstractArmorTrait
implements IncrementalModifier {
    protected final String baseIdentifier;
    protected final int levelMax;
    protected final int level;

    public StackableArmourTrait(String identifier, int color, int levelMax, int level) {
        super(identifier + level, color);
        this.baseIdentifier = identifier + "_armor";
        this.levelMax = levelMax;
        this.level = level;
        if (level == 1) {
            TinkerRegistry.registerModifierAlias((IModifier)this, (String)this.baseIdentifier);
        }
        this.aspects.clear();
        this.addAspects(new ModifierAspect[]{new ModifierAspect.LevelAspect((IModifier)this, levelMax), new ModifierAspect.DataAspect((IModifier)this, color)});
    }

    @Override
    public String getBaseIdentifier() {
        return this.baseIdentifier;
    }

    @Override
    public int getLevelIncrement() {
        return this.level;
    }

    @Override
    public int getLevelMaximum() {
        return this.levelMax;
    }

    public boolean isToolWithStackableTrait(ItemStack stack) {
        return ToolUtils.hasModifier(stack, this.getBaseIdentifier());
    }

    public void updateNBTforTrait(NBTTagCompound modifierTag, int newColor) {
        super.updateNBTforTrait(modifierTag, newColor);
        ModifierNBT data = ModifierNBT.readTag((NBTTagCompound)modifierTag);
        data.level = 0;
        data.write(modifierTag);
    }

    public void applyEffect(NBTTagCompound rootCompound, NBTTagCompound modifierTag) {
        super.applyEffect(rootCompound, modifierTag);
        StackableTrait.applyStacks(this, rootCompound, this.color);
    }

    public String getModifierIdentifier() {
        return this.baseIdentifier;
    }

    public String getLocalizedName() {
        String name = Util.translate((String)"modifier.%s.name", (Object[])new Object[]{this.baseIdentifier});
        return this.level > 1 ? name + " " + TinkerUtil.getRomanNumeral((int)this.level) : name;
    }

    public String getLocalizedDesc() {
        return Util.translate((String)"modifier.%s.desc", (Object[])new Object[]{this.baseIdentifier});
    }

    public String getTooltip(NBTTagCompound modifierTag, boolean detailed) {
        return this.getLeveledTooltip(modifierTag, detailed);
    }
}

