/*
 * Decompiled with CFR 0.152.
 */
package xyz.phanta.tconevo.integration.conarm.trait.draconicevolution;

import c4.conarm.lib.modifiers.ArmorModifierTrait;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextFormatting;
import slimeknights.tconstruct.library.modifiers.ModifierAspect;
import xyz.phanta.tconevo.util.ToolUtils;

public class ArmourModDraconic
extends ArmorModifierTrait {
    static final List<ArmourModDraconic> allMods = new ArrayList<ArmourModDraconic>();
    @Nullable
    private final Set<EntityEquipmentSlot> eligibleEqSlots;

    public ArmourModDraconic(String name, int colour, int maxLevel, EntityEquipmentSlot ... eligibleEqSlots) {
        super(name, colour, maxLevel + 1, 0);
        this.eligibleEqSlots = eligibleEqSlots.length > 0 ? EnumSet.copyOf(Arrays.asList(eligibleEqSlots)) : null;
        this.aspects.remove(this.aspects.lastIndexOf(ModifierAspect.freeModifier));
        allMods.add(this);
    }

    public ArmourModDraconic(String name, EntityEquipmentSlot ... eligibleEqSlots) {
        this(name, 43690, 4, eligibleEqSlots);
    }

    public final void applyEffect(NBTTagCompound rootCompound, NBTTagCompound modifierTag) {
        super.applyEffect(rootCompound, modifierTag);
        int level = ToolUtils.getTraitLevel(modifierTag);
        if (level > 1) {
            this.applyDraconicEffect(rootCompound, level - 1);
        }
    }

    protected void applyDraconicEffect(NBTTagCompound rootTag, int tier) {
    }

    public boolean isEligible(NBTTagCompound root, EntityEquipmentSlot slot) {
        return this.eligibleEqSlots == null || this.eligibleEqSlots.contains(slot);
    }

    public String getLeveledTooltip(int level, @Nullable String suffix) {
        return String.format("%s " + TextFormatting.GOLD + "%s%s", this.getLocalizedName(), I18n.func_135052_a((String)("upgrade.level." + (level - 1)), (Object[])new Object[0]), suffix);
    }

    protected int getDraconicTier(ItemStack stack) {
        return ToolUtils.getTraitLevel(stack, this.identifier) - 1;
    }
}

