/*
 * Decompiled with CFR 0.152.
 */
package xyz.phanta.tconevo.integration.conarm.trait.draconicevolution;

import io.github.phantamanta44.libnine.capability.provider.CapabilityBroker;
import io.github.phantamanta44.libnine.util.helper.ItemUtils;
import io.github.phantamanta44.libnine.util.helper.OptUtils;
import io.github.phantamanta44.libnine.util.math.MathUtils;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import slimeknights.tconstruct.library.utils.TinkerUtil;
import xyz.phanta.tconevo.TconEvoConfig;
import xyz.phanta.tconevo.TconEvoMod;
import xyz.phanta.tconevo.capability.EnergyShield;
import xyz.phanta.tconevo.client.event.ItemStackBarEvent;
import xyz.phanta.tconevo.init.TconEvoCaps;
import xyz.phanta.tconevo.integration.conarm.ConArmHooks;
import xyz.phanta.tconevo.integration.conarm.trait.base.StackableArmourTrait;
import xyz.phanta.tconevo.integration.conarm.trait.draconicevolution.ArmourModDraconic;
import xyz.phanta.tconevo.trait.base.EnergeticModifier;
import xyz.phanta.tconevo.trait.draconicevolution.TraitEvolved;
import xyz.phanta.tconevo.util.ToolUtils;

public class ArmourTraitEvolved
extends StackableArmourTrait
implements EnergeticModifier {
    private static final String TAG_EVOLVED_INIT = "ConArmEvolvedInit";

    public ArmourTraitEvolved(int level) {
        super("tconevo.evolved", 13146868, 3, level);
        if (level == 1) {
            TconEvoMod.PROXY.getToolCapHandler().addModifierCap("tconevo.evolved_armor", s -> {
                EvolvedArmourCap cap = new EvolvedArmourCap((ItemStack)s);
                return new CapabilityBroker().with(CapabilityEnergy.ENERGY, (Object)cap).with(TconEvoCaps.ENERGY_SHIELD, (Object)cap);
            });
            MinecraftForge.EVENT_BUS.register((Object)this);
        }
    }

    @Override
    public void applyEffect(NBTTagCompound rootCompound, NBTTagCompound modifierTag) {
        if (modifierTag.func_74762_e("level") == 0) {
            super.applyEffect(rootCompound, modifierTag);
            rootCompound.func_74757_a("Unbreakable", true);
            EntityEquipmentSlot slot = ConArmHooks.INSTANCE.getArmourType(rootCompound);
            if (slot != null) {
                this.initDraconicModifiers(rootCompound, slot);
            }
        } else {
            super.applyEffect(rootCompound, modifierTag);
        }
    }

    public void initDraconicModifiers(NBTTagCompound rootTag, EntityEquipmentSlot slot) {
        if (rootTag.func_74764_b(TAG_EVOLVED_INIT)) {
            return;
        }
        for (ArmourModDraconic mod : ArmourModDraconic.allMods) {
            if (!mod.isEligible(rootTag, slot) || TinkerUtil.hasTrait((NBTTagCompound)rootTag, (String)mod.identifier)) continue;
            mod.apply(rootTag);
        }
        rootTag.func_74757_a(TAG_EVOLVED_INIT, true);
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onItemStackBars(ItemStackBarEvent event) {
        if (this.isToolWithStackableTrait(event.stack)) {
            event.addForgeEnergyBar();
        }
    }

    private static class EvolvedArmourCap
    extends TraitEvolved.EvolvedCap
    implements EnergyShield {
        private static final String TAG_SHIELD = "EvolvedShieldPoints";
        private static final String TAG_ENTROPY = "EvolvedShieldEntropy";

        EvolvedArmourCap(ItemStack stack) {
            super(stack);
        }

        @Override
        public void setEnergyStored(int amount) {
            ItemUtils.getOrCreateTag((ItemStack)this.stack).func_74768_a("EvolvedEnergy", amount);
        }

        @Override
        protected int getEnergyTier() {
            return ToolUtils.getTraitLevel(this.stack, "tconevo.draconic_energy_armor");
        }

        @Override
        public float getShieldPoints() {
            return OptUtils.stackTag((ItemStack)this.stack).map(t -> Float.valueOf(t.func_74760_g(TAG_SHIELD))).orElse(Float.valueOf(0.0f)).floatValue();
        }

        @Override
        public float getShieldCapacity() {
            return (float)(TconEvoConfig.moduleDraconicEvolution.getBaseShieldCapacity(TraitEvolved.getEvolvedTier(this.stack)) * ToolUtils.getTraitLevel(this.stack, "tconevo.draconic_shield_capacity_armor")) * EvolvedArmourCap.getShieldPartition(EntityLiving.func_184640_d((ItemStack)this.stack));
        }

        @Override
        public int getShieldCost() {
            return TconEvoConfig.moduleDraconicEvolution.getShieldRecoveryEnergy(TraitEvolved.getEvolvedTier(this.stack));
        }

        @Override
        public void setShield(float amount) {
            ItemUtils.getOrCreateTag((ItemStack)this.stack).func_74776_a(TAG_SHIELD, MathUtils.clamp((float)amount, (float)0.0f, (float)this.getShieldCapacity()));
        }

        @Override
        public float getEntropy() {
            return OptUtils.stackTag((ItemStack)this.stack).map(t -> Float.valueOf(t.func_74760_g(TAG_ENTROPY))).orElse(Float.valueOf(0.0f)).floatValue();
        }

        @Override
        public float getShieldRecovery() {
            return (float)TconEvoConfig.moduleDraconicEvolution.getBaseShieldRecovery(TraitEvolved.getEvolvedTier(this.stack)) * (float)ToolUtils.getTraitLevel(this.stack, "tconevo.draconic_shield_recovery_armor");
        }

        @Override
        public void setEntropy(float amount) {
            ItemUtils.getOrCreateTag((ItemStack)this.stack).func_74776_a(TAG_ENTROPY, MathUtils.clamp((float)amount, (float)0.0f, (float)100.0f));
        }

        @Override
        public void onDamageAbsorbed(float damage, EntityPlayer player) {
            if (TconEvoConfig.moduleDraconicEvolution.shieldedDamageGrantsToolXp) {
                ConArmHooks.INSTANCE.addArmourXpFromDamage(this.stack, damage, player);
            }
        }

        private static float getShieldPartition(EntityEquipmentSlot slot) {
            switch (slot) {
                case HEAD: 
                case FEET: {
                    return 0.15f;
                }
                case CHEST: {
                    return 0.4f;
                }
                case LEGS: {
                    return 0.3f;
                }
            }
            return 1.0f;
        }
    }
}

