/*
 * Decompiled with CFR 0.152.
 */
package xyz.phanta.tconevo.integration.crafttweaker;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.annotations.ZenRegister;
import java.util.NoSuchElementException;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.materials.IMaterialStats;
import slimeknights.tconstruct.library.materials.Material;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;
import xyz.phanta.tconevo.material.stats.MagicMaterialStats;

@ZenRegister
@ZenClass(value="mods.tconevo.TconEvo")
public class CrTClassTconEvo {
    @ZenMethod
    public static void setMagicMaterialStats(final String materialId, final int durability, final float potency, final float range, final int harvestLevel) {
        CraftTweakerAPI.apply((IAction)new IAction(){

            public void apply() {
                Material mat = TinkerRegistry.getMaterial((String)materialId);
                if (mat == null) {
                    throw new NoSuchElementException("Unknown material: " + materialId);
                }
                if (mat.hasStats("tconevo.magic")) {
                    mat.addStats((IMaterialStats)new MagicMaterialStats(durability, potency, range, harvestLevel));
                } else {
                    TinkerRegistry.addMaterialStats((Material)mat, (IMaterialStats)new MagicMaterialStats(durability, potency, range, harvestLevel));
                }
            }

            public String describe() {
                return String.format("Setting magic material stats for %s to {dur=%d,pot=%f,ran=%f,har=%d}", materialId, durability, Float.valueOf(potency), Float.valueOf(range), harvestLevel);
            }
        });
    }
}

