/*
 * Decompiled with CFR 0.152.
 */
package xyz.phanta.tconevo.integration.draconicevolution;

import com.brandon3055.draconicevolution.DEConfig;
import com.brandon3055.draconicevolution.DEFeatures;
import com.brandon3055.draconicevolution.DraconicEvolution;
import com.brandon3055.draconicevolution.achievements.Achievements;
import com.brandon3055.draconicevolution.api.fusioncrafting.FusionRecipeAPI;
import com.brandon3055.draconicevolution.api.fusioncrafting.IFusionRecipe;
import com.brandon3055.draconicevolution.api.fusioncrafting.SimpleFusionRecipe;
import com.brandon3055.draconicevolution.capabilities.IShieldState;
import com.brandon3055.draconicevolution.capabilities.ShieldStateProvider;
import com.brandon3055.draconicevolution.integration.ModHelper;
import com.brandon3055.draconicevolution.items.armor.ICustomArmor;
import com.brandon3055.draconicevolution.items.armor.WyvernArmor;
import com.brandon3055.draconicevolution.lib.DEDamageSources;
import com.brandon3055.draconicevolution.magic.EnchantmentReaper;
import com.brandon3055.draconicevolution.network.PacketShieldHit;
import com.google.common.collect.Sets;
import io.github.phantamanta44.libnine.util.helper.ItemUtils;
import io.github.phantamanta44.libnine.util.helper.OptUtils;
import io.github.phantamanta44.libnine.util.math.MathUtils;
import io.github.phantamanta44.libnine.util.tuple.IPair;
import io.github.phantamanta44.libnine.util.world.WorldUtils;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import slimeknights.tconstruct.library.modifiers.Modifier;
import xyz.phanta.tconevo.init.TconEvoItems;
import xyz.phanta.tconevo.init.TconEvoTraits;
import xyz.phanta.tconevo.integration.draconicevolution.DamageSourcePrimordial;
import xyz.phanta.tconevo.integration.draconicevolution.DraconicHooks;
import xyz.phanta.tconevo.integration.draconicevolution.DraconicUpgradeRecipe;
import xyz.phanta.tconevo.item.ItemMaterial;
import xyz.phanta.tconevo.item.ItemMetal;
import xyz.phanta.tconevo.util.ToolUtils;

public class DraconicHooksImpl
implements DraconicHooks {
    private static final Set<String> CHAOS_DAMAGE_NAMES = Sets.newHashSet((Object[])new String[]{"de.GuardianFireball", "de.GuardianEnergyBall", "de.GuardianChaosBall", "chaosImplosion", "damage.de.fusionExplode", "de.islandImplode"});

    @Override
    public void onPreInit(FMLPreInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public void onInit(FMLInitializationEvent event) {
        FusionRecipeAPI.addRecipe((IFusionRecipe)new SimpleFusionRecipe(TconEvoItems.METAL.newStack(ItemMetal.Type.WYVERN_METAL, ItemMetal.Form.INGOT, 1), ItemMaterial.Type.COALESCENCE_MATRIX.newStack(1), 64000L, 1, new Object[]{DEFeatures.wyvernCore, "blockRedstone", "gemDiamond", "gemDiamond"}));
        FusionRecipeAPI.addRecipe((IFusionRecipe)new SimpleFusionRecipe(TconEvoItems.METAL.newStack(ItemMetal.Type.DRACONIC_METAL, ItemMetal.Form.INGOT, 1), ItemMaterial.Type.COALESCENCE_MATRIX.newStack(1), 1024000L, 2, new Object[]{DEFeatures.awakenedCore, DEFeatures.wyvernEnergyCore, Items.field_151156_bN, Items.field_151156_bN}));
        FusionRecipeAPI.addRecipe((IFusionRecipe)new SimpleFusionRecipe(TconEvoItems.METAL.newStack(ItemMetal.Type.CHAOTIC_METAL, ItemMetal.Form.INGOT, 1), ItemMaterial.Type.COALESCENCE_MATRIX.newStack(1), 256000000L, 3, new Object[]{DEFeatures.chaoticCore, DEFeatures.draconicEnergyCore, "dragonEgg", "dragonEgg"}));
        this.addUpgradeRecipes((Modifier)TconEvoTraits.MOD_DRACONIC_ENERGY, "rfCap");
        this.addUpgradeRecipes((Modifier)TconEvoTraits.MOD_DRACONIC_DIG_SPEED, "digSpeed");
        this.addUpgradeRecipes((Modifier)TconEvoTraits.MOD_DRACONIC_DIG_AOE, "digAOE");
        this.addUpgradeRecipes((Modifier)TconEvoTraits.MOD_DRACONIC_ATTACK_DAMAGE, "attackDmg");
        this.addUpgradeRecipes((Modifier)TconEvoTraits.MOD_DRACONIC_ATTACK_AOE, "attackAOE");
        this.addUpgradeRecipes((Modifier)TconEvoTraits.MOD_DRACONIC_ARROW_DAMAGE, "arrowDmg");
        this.addUpgradeRecipes((Modifier)TconEvoTraits.MOD_DRACONIC_DRAW_SPEED, "drawSpeed");
        this.addUpgradeRecipes((Modifier)TconEvoTraits.MOD_DRACONIC_ARROW_SPEED, "arrowSpeed");
    }

    @Override
    public Optional<ItemStack> getItemEnderEnergyManipulator() {
        return Optional.of(new ItemStack((Item)DEFeatures.enderEnergyManipulator));
    }

    @Override
    public Optional<ItemStack> getItemWyvernEnergyCore() {
        return Optional.of(new ItemStack(DEFeatures.wyvernEnergyCore));
    }

    @Override
    public Optional<ItemStack> getItemDraconicEnergyCore() {
        return Optional.of(new ItemStack(DEFeatures.draconicEnergyCore));
    }

    @Override
    public Optional<ItemStack> getItemChaosShard() {
        return Optional.of(new ItemStack((Item)DEFeatures.chaosShard));
    }

    @Override
    public Optional<ItemStack> getItemDragonHeart() {
        return Optional.of(new ItemStack((Item)DEFeatures.dragonHeart));
    }

    @Override
    public Optional<ItemStack> getItemReactorStabilizer() {
        return Optional.of(new ItemStack((Block)DEFeatures.reactorComponent, 1, 0));
    }

    @Override
    public Optional<ItemStack> getItemWyvernCapacitor() {
        return Optional.of(DEFeatures.wyvernCapacitor.func_77946_l());
    }

    @Override
    public Optional<ItemStack> getItemDraconicCapacitor() {
        return Optional.of(DEFeatures.draconicCapacitor.func_77946_l());
    }

    @Override
    public void addUpgradeRecipes(Modifier upgradeMod, String upgradeKey) {
        FusionRecipeAPI.addRecipe((IFusionRecipe)new DraconicUpgradeRecipe(upgradeMod, upgradeKey, 0, Items.field_151153_ao, Items.field_151153_ao, "gemDiamond", "gemDiamond", Items.field_151061_bv, Items.field_151061_bv, DEFeatures.draconicCore));
        FusionRecipeAPI.addRecipe((IFusionRecipe)new DraconicUpgradeRecipe(upgradeMod, upgradeKey, 1, Items.field_151156_bN, Items.field_151156_bN, DEFeatures.draconicCore, DEFeatures.draconicCore, "gemEmerald", "gemEmerald", DEFeatures.wyvernCore));
        FusionRecipeAPI.addRecipe((IFusionRecipe)new DraconicUpgradeRecipe(upgradeMod, upgradeKey, 2, Items.field_151156_bN, Items.field_151156_bN, DEFeatures.wyvernCore, DEFeatures.wyvernCore, "blockEmerald", "blockEmerald", DEFeatures.awakenedCore));
        FusionRecipeAPI.addRecipe((IFusionRecipe)new DraconicUpgradeRecipe(upgradeMod, upgradeKey, 3, DEFeatures.wyvernCore, DEFeatures.wyvernCore, DEFeatures.awakenedCore, DEFeatures.awakenedCore, Blocks.field_150380_bt, Blocks.field_150380_bt, DEFeatures.chaoticCore));
    }

    @Override
    public boolean isReaperEnchantment(Enchantment ench) {
        return ench == EnchantmentReaper.instance;
    }

    @SubscribeEvent
    public void onLivingDrops(LivingDropsEvent event) {
        int baseOdds;
        EntityLivingBase victim = event.getEntityLiving();
        if (victim.field_70170_p.field_72995_K) {
            return;
        }
        DamageSource dmgSrc = event.getSource();
        switch (dmgSrc.field_76373_n) {
            case "player": 
            case "arrow": {
                break;
            }
            default: {
                return;
            }
        }
        Entity attacker = dmgSrc.func_76346_g();
        if (!(attacker instanceof EntityPlayer) || !this.isEligibleForReaper(victim)) {
            return;
        }
        ItemStack weapon = ToolUtils.getAttackerWeapon(dmgSrc, (EntityLivingBase)((EntityPlayer)attacker));
        if (weapon.func_190926_b()) {
            return;
        }
        int reapLevel = ToolUtils.getTraitLevel(weapon, "tconevo.reaping") + ToolUtils.getTraitLevel(weapon, "tconevo.soul_rend");
        if (reapLevel <= 0) {
            return;
        }
        int n = baseOdds = victim instanceof EntityAnimal ? DEConfig.passiveSoulDropChance : DEConfig.soulDropChance;
        if (victim.field_70170_p.field_73012_v.nextInt(Math.max(baseOdds / reapLevel, 1)) == 0) {
            WorldUtils.dropItem((World)victim.field_70170_p, (Vec3d)victim.func_174791_d(), (ItemStack)DEFeatures.mobSoul.getSoulFromEntity((Entity)victim, false));
            Achievements.triggerAchievement((EntityPlayer)((EntityPlayer)attacker), (String)"draconicevolution.soul");
        }
    }

    private boolean isEligibleForReaper(EntityLivingBase entity) {
        if (!entity.func_184222_aU() && !DEConfig.allowBossSouls) {
            return false;
        }
        if (DEConfig.spawnerListWhiteList) {
            for (String entry : DEConfig.spawnerList) {
                if (!entry.equals(entity.func_70005_c_())) continue;
                return true;
            }
            return false;
        }
        for (String entry : DEConfig.spawnerList) {
            if (!entry.equals(entity.func_70005_c_())) continue;
            return false;
        }
        return true;
    }

    @Override
    public void playShieldHitEffect(EntityPlayer player, float shieldPower) {
        DraconicEvolution.network.sendToAllAround((IMessage)new PacketShieldHit(player, shieldPower), new NetworkRegistry.TargetPoint(player.field_71093_bK, player.field_70165_t, player.field_70163_u, player.field_70161_v, 64.0));
    }

    @Override
    public boolean isShieldEnabled(EntityPlayer player) {
        return OptUtils.capability((ICapabilityProvider)player, (Capability)ShieldStateProvider.PLAYER_CAP).map(IShieldState::getShieldState).orElse(true);
    }

    @Override
    @Nullable
    public IPair<Float, Float> applyShieldDamageModifiers(EntityPlayer victim, EntityPlayer attacker, float shieldPoints, float damage) {
        if (ModHelper.isHoldingAvaritiaSword((EntityPlayer)attacker)) {
            victim.field_70172_ad = 0;
            return IPair.of((Object)Float.valueOf(Math.max(damage, 300.0f)), (Object)Float.valueOf(0.0f));
        }
        if (ModHelper.isHoldingBedrockSword((EntityPlayer)attacker)) {
            return IPair.of((Object)Float.valueOf(Math.max(damage, Math.min(50.0f, shieldPoints))), (Object)Float.valueOf(10.0f));
        }
        return null;
    }

    @Override
    public boolean inflictEntropy(ItemStack stack, float amount) {
        if (stack.func_77973_b() instanceof ICustomArmor) {
            NBTTagCompound tag = ItemUtils.getOrCreateTag((ItemStack)stack);
            tag.func_74776_a("ShieldEntropy", Math.min(tag.func_74760_g("ShieldEntropy") + amount, 100.0f));
            return true;
        }
        return false;
    }

    @Override
    public int burnArmourEnergy(ItemStack stack, float fraction, int minBurn, int maxBurn) {
        if (stack.func_77973_b() instanceof WyvernArmor) {
            WyvernArmor armourItem = (WyvernArmor)stack.func_77973_b();
            int stored = armourItem.getEnergyStored(stack);
            int burned = Math.min(MathUtils.clamp((int)((int)Math.ceil((float)stored * fraction)), (int)minBurn, (int)maxBurn), stored);
            armourItem.modifyEnergy(stack, -burned);
            return burned;
        }
        return 0;
    }

    @Override
    public DamageSource getChaosDamage(EntityLivingBase attacker) {
        return new DamageSourcePrimordial((Entity)attacker);
    }

    @Override
    public boolean isChaosDamage(DamageSource dmgSrc) {
        return dmgSrc instanceof DEDamageSources.DamageSourceChaos || CHAOS_DAMAGE_NAMES.contains(dmgSrc.field_76373_n);
    }
}

