/*
 * Decompiled with CFR 0.152.
 */
package xyz.phanta.tconevo.integration.draconicevolution;

import com.brandon3055.draconicevolution.DEFeatures;
import com.brandon3055.draconicevolution.api.OreDictHelper;
import com.brandon3055.draconicevolution.api.fusioncrafting.ICraftingInjector;
import com.brandon3055.draconicevolution.api.fusioncrafting.IFusionCraftingInventory;
import com.brandon3055.draconicevolution.api.fusioncrafting.IFusionRecipe;
import com.brandon3055.draconicevolution.items.ToolUpgrade;
import io.github.phantamanta44.libnine.util.helper.OptUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import slimeknights.tconstruct.library.events.TinkerCraftingEvent;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.TinkerGuiException;
import slimeknights.tconstruct.library.tinkering.ITinkerable;
import slimeknights.tconstruct.library.utils.TinkerUtil;
import xyz.phanta.tconevo.TconEvoMod;
import xyz.phanta.tconevo.integration.gamestages.GameStagesHooks;
import xyz.phanta.tconevo.trait.draconicevolution.TraitEvolved;
import xyz.phanta.tconevo.util.ToolUtils;

public class DraconicUpgradeRecipe
implements IFusionRecipe {
    private static final int[] UPGRADE_COSTS = new int[]{32000, 512000, 32000000, 256000000};
    private final Modifier upgradeMod;
    private final ItemStack upgradeKey;
    private final int tier;
    private final List<Object> ingredients;

    public DraconicUpgradeRecipe(Modifier upgradeMod, String upgradeKey, int tier, Object ... ingredients) {
        if (tier < 0 || tier >= UPGRADE_COSTS.length) {
            throw new IllegalArgumentException("Bad draconic upgrade level: " + tier);
        }
        this.upgradeMod = upgradeMod;
        this.upgradeKey = new ItemStack((Item)DEFeatures.toolUpgrade, 1, ((Integer)ToolUpgrade.NAME_TO_ID.get(upgradeKey)).intValue());
        this.tier = tier;
        this.ingredients = new ArrayList<Object>(Arrays.asList(ingredients));
        this.ingredients.add(this.upgradeKey);
    }

    public Modifier getModifier() {
        return this.upgradeMod;
    }

    public int getRecipeTier() {
        return this.tier;
    }

    public List<Object> getRecipeIngredients() {
        return this.ingredients;
    }

    public long getIngredientEnergyCost() {
        return UPGRADE_COSTS[this.tier];
    }

    public ItemStack getRecipeCatalyst() {
        return ItemStack.field_190927_a;
    }

    public boolean isRecipeCatalyst(ItemStack stack) {
        if (!(stack.func_77973_b() instanceof ITinkerable)) {
            return false;
        }
        return OptUtils.stackTag((ItemStack)stack).map(t -> (ToolUtils.hasModifier(t, "tconevo.evolved") || ToolUtils.hasModifier(t, "tconevo.evolved_armor")) && TinkerUtil.hasTrait((NBTTagCompound)t, (String)this.upgradeMod.identifier)).orElse(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ItemStack getRecipeOutput(@Nullable ItemStack stack) {
        if (stack == null || stack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        ItemStack result = stack.func_77946_l();
        try {
            GameStagesHooks.INSTANCE.startBypass();
            this.upgradeMod.apply(result);
            TinkerCraftingEvent.ToolModifyEvent.fireEvent((ItemStack)result, null, (ItemStack)stack.func_77946_l());
            ToolUtils.rebuildToolStack(result);
        }
        catch (TinkerGuiException e) {
            TconEvoMod.LOGGER.warn("Draconic tool upgrade failed", (Throwable)e);
            ItemStack itemStack = ItemStack.field_190927_a;
            return itemStack;
        }
        finally {
            GameStagesHooks.INSTANCE.endBypass();
        }
        return result;
    }

    public boolean matches(IFusionCraftingInventory inv, World world, BlockPos pos) {
        if (!this.isRecipeCatalyst(inv.getStackInCore(0))) {
            return false;
        }
        HashSet injectors = new HashSet(inv.getInjectors());
        block0: for (Object ing : this.ingredients) {
            Iterator iter = injectors.iterator();
            while (iter.hasNext()) {
                ItemStack injStack = ((ICraftingInjector)iter.next()).getStackInPedestal();
                if (injStack.func_190926_b() || !OreDictHelper.areStacksEqual((Object)ing, (ItemStack)injStack)) continue;
                iter.remove();
                continue block0;
            }
            return false;
        }
        for (ICraftingInjector inj : injectors) {
            if (inj.getStackInPedestal().func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public String canCraft(IFusionCraftingInventory inv, World world, BlockPos pos) {
        ItemStack tool = inv.getStackInCore(0);
        if (!this.isRecipeCatalyst(tool)) {
            return "upgrade.de.upgradeNA.info";
        }
        if (!inv.getStackInCore(1).func_190926_b()) {
            return "outputObstructed";
        }
        if (TraitEvolved.getEvolvedTier(tool) < this.tier) {
            return "upgrade.de.upgradeLevelToHigh.info";
        }
        try {
            if (!this.upgradeMod.canApply(tool, tool)) {
                return "upgrade.de.upgradeApplied.info";
            }
        }
        catch (TinkerGuiException e) {
            return e.getMessage();
        }
        int currentLevel = ToolUtils.getTraitLevel(tool, this.upgradeMod.identifier);
        if (currentLevel <= this.tier) {
            return "upgrade.de.upgradePrevLevelRequired.info";
        }
        if (currentLevel > this.tier + 1) {
            return "upgrade.de.upgradeApplied.info";
        }
        for (ICraftingInjector inj : inv.getInjectors()) {
            if (inj.getStackInPedestal().func_190926_b() || inj.getPedestalTier() >= this.tier) continue;
            return "tierLow";
        }
        return "true";
    }

    public void craft(IFusionCraftingInventory inv, World world, BlockPos pos) {
        if (this.matches(inv, world, pos)) {
            HashSet injectors = new HashSet(inv.getInjectors());
            block0: for (Object ing : this.ingredients) {
                Iterator iter = injectors.iterator();
                while (iter.hasNext()) {
                    ICraftingInjector inj = (ICraftingInjector)iter.next();
                    ItemStack injStack = inj.getStackInPedestal();
                    if (injStack.func_190926_b() || !OreDictHelper.areStacksEqual((Object)ing, (ItemStack)injStack)) continue;
                    if (ing != this.upgradeKey) {
                        if (injStack.func_77973_b().hasContainerItem(injStack)) {
                            inj.setStackInPedestal(injStack.func_77973_b().getContainerItem(injStack));
                        } else if (injStack.func_190916_E() == 1) {
                            inj.setStackInPedestal(ItemStack.field_190927_a);
                        } else {
                            injStack.func_190918_g(1);
                        }
                    }
                    iter.remove();
                    continue block0;
                }
            }
            ItemStack output = this.getRecipeOutput(inv.getStackInCore(0));
            inv.setStackInCore(0, ItemStack.field_190927_a);
            inv.setStackInCore(1, output);
        }
    }

    public void onCraftingTick(IFusionCraftingInventory inv, World world, BlockPos pos) {
    }
}

