/*
 * Decompiled with CFR 0.152.
 */
package xyz.phanta.tconevo.integration.enderio;

import crazypants.enderio.base.fluid.Fluids;
import crazypants.enderio.base.init.IModObjectBase;
import crazypants.enderio.base.init.ModObject;
import crazypants.enderio.machines.machine.solar.ISolarType;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import slimeknights.tconstruct.library.TinkerRegistry;
import xyz.phanta.tconevo.TconEvoConfig;
import xyz.phanta.tconevo.integration.enderio.EnderIoHooks;
import xyz.phanta.tconevo.trait.ModifierPhotovoltaic;

public class EnderIoHooksImpl
implements EnderIoHooks {
    @Override
    public void onPostInit(FMLPostInitializationEvent event) {
        if (TconEvoConfig.moduleEnderIo.fuelFireWaterBurnTime > 0) {
            TinkerRegistry.registerSmelteryFuel((FluidStack)new FluidStack(Fluids.FIRE_WATER.getFluid(), 50), (int)TconEvoConfig.moduleEnderIo.fuelFireWaterBurnTime);
        }
        for (ISolarType type : ISolarType.KIND.getOrderedValues()) {
            ModifierPhotovoltaic.registerSolarItem(type.getItemStack(), type.getRfperSecond());
        }
    }

    @Override
    public Optional<ItemStack> getItemInvChargerSimple() {
        return EnderIoHooksImpl.getModObjStack((IModObjectBase)ModObject.itemInventoryChargerSimple);
    }

    @Override
    public Optional<ItemStack> getItemInvChargerBasic() {
        return EnderIoHooksImpl.getModObjStack((IModObjectBase)ModObject.itemInventoryChargerBasic);
    }

    @Override
    public Optional<ItemStack> getItemInvChargerNormal() {
        return EnderIoHooksImpl.getModObjStack((IModObjectBase)ModObject.itemInventoryCharger);
    }

    @Override
    public Optional<ItemStack> getItemInvChargerVibrant() {
        return EnderIoHooksImpl.getModObjStack((IModObjectBase)ModObject.itemInventoryChargerVibrant);
    }

    @Override
    public Collection<ItemStack> getSolarItems() {
        return ISolarType.KIND.getOrderedValues().stream().map(ISolarType::getItemStack).collect(Collectors.toList());
    }

    private static Optional<ItemStack> getModObjStack(IModObjectBase type) {
        return Optional.ofNullable(type.getItem()).map(ItemStack::new);
    }
}

