/*
 * Decompiled with CFR 0.152.
 */
package xyz.phanta.tconevo.integration.ic2;

import ic2.api.item.ElectricItem;
import ic2.api.item.IBackupElectricItemManager;
import ic2.api.item.IElectricItem;
import io.github.phantamanta44.libnine.util.format.FormatUtils;
import io.github.phantamanta44.libnine.util.helper.OptUtils;
import java.awt.Color;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import slimeknights.tconstruct.library.client.CustomFontColor;
import xyz.phanta.tconevo.capability.EuStore;
import xyz.phanta.tconevo.init.TconEvoCaps;

public class EuStoreItemHandler
implements IBackupElectricItemManager {
    public static final EuStoreItemHandler INSTANCE = new EuStoreItemHandler();
    private static final EntityEquipmentSlot[] ARMOUR_SLOTS = new EntityEquipmentSlot[]{EntityEquipmentSlot.HEAD, EntityEquipmentSlot.CHEST, EntityEquipmentSlot.LEGS, EntityEquipmentSlot.FEET};

    private EuStoreItemHandler() {
    }

    public boolean handles(ItemStack stack) {
        return stack.hasCapability(TconEvoCaps.EU_STORE, null);
    }

    public double charge(ItemStack stack, double amount, int tier, boolean ignoreTfrRate, boolean simulate) {
        return OptUtils.capability((ICapabilityProvider)stack, TconEvoCaps.EU_STORE).filter(e -> tier >= e.getEuTier()).map(e -> e.injectEu(amount, ignoreTfrRate, !simulate)).orElse(0.0);
    }

    public double discharge(ItemStack stack, double amount, int tier, boolean ignoreTfrRate, boolean external, boolean simulate) {
        return OptUtils.capability((ICapabilityProvider)stack, TconEvoCaps.EU_STORE).filter(e -> (!external || e.canExtractEu()) && tier >= e.getEuTier()).map(e -> e.extractEu(amount, ignoreTfrRate, !simulate)).orElse(0.0);
    }

    public double getCharge(ItemStack stack) {
        return OptUtils.capability((ICapabilityProvider)stack, TconEvoCaps.EU_STORE).map(EuStore::getEuStored).orElse(0.0);
    }

    public double getMaxCharge(ItemStack stack) {
        return OptUtils.capability((ICapabilityProvider)stack, TconEvoCaps.EU_STORE).map(EuStore::getEuStoredMax).orElse(0.0);
    }

    public boolean canUse(ItemStack stack, double amount) {
        return this.getCharge(stack) >= amount;
    }

    public boolean use(ItemStack stack, double amount, EntityLivingBase entity) {
        double transfer;
        if (entity != null) {
            this.chargeFromArmor(stack, entity);
        }
        if (Math.abs((transfer = this.discharge(stack, amount, Integer.MAX_VALUE, true, false, true)) - amount) < 1.0E-5) {
            this.discharge(stack, amount, Integer.MAX_VALUE, true, false, false);
            if (entity != null) {
                this.chargeFromArmor(stack, entity);
            }
            return true;
        }
        return false;
    }

    public void chargeFromArmor(ItemStack stack, EntityLivingBase entity) {
        boolean transferred = false;
        for (EntityEquipmentSlot slot : ARMOUR_SLOTS) {
            double transfer;
            ItemStack source = entity.func_184582_a(slot);
            if (source.func_190926_b() || !((transfer = ElectricItem.manager.discharge(source, Double.POSITIVE_INFINITY, Integer.MAX_VALUE, true, true, true)) > 0.0) || !((transfer = this.charge(stack, transfer, source.func_77973_b() instanceof IElectricItem ? ((IElectricItem)source.func_77973_b()).getTier(source) : Integer.MAX_VALUE, true, false)) > 0.0)) continue;
            ElectricItem.manager.discharge(source, transfer, Integer.MAX_VALUE, true, true, false);
            transferred = true;
        }
        if (transferred && entity instanceof EntityPlayer) {
            ((EntityPlayer)entity).field_71070_bA.func_75142_b();
        }
    }

    @Nullable
    public String getToolTip(ItemStack stack) {
        return OptUtils.capability((ICapabilityProvider)stack, TconEvoCaps.EU_STORE).map(energy -> {
            double stored = energy.getEuStored();
            double max = energy.getEuStoredMax();
            return String.format("%s%s / %s", CustomFontColor.encodeColor((int)Color.HSBtoRGB(0.33f * (float)(stored / max), 1.0f, 0.67f)), FormatUtils.formatSI((double)stored, (String)"EU"), FormatUtils.formatSI((double)max, (String)"EU"));
        }).orElse(null);
    }

    public int getTier(ItemStack stack) {
        return OptUtils.capability((ICapabilityProvider)stack, TconEvoCaps.EU_STORE).map(EuStore::getEuTier).orElse(0);
    }
}

