/*
 * Decompiled with CFR 0.152.
 */
package xyz.phanta.tconevo.integration.ic2;

import ic2.api.item.ElectricItem;
import ic2.api.item.IBackupElectricItemManager;
import ic2.api.item.IC2Items;
import ic2.api.recipe.ICannerEnrichRecipeManager;
import ic2.api.recipe.Recipes;
import java.util.Optional;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.items.ItemHandlerHelper;
import slimeknights.tconstruct.library.TinkerRegistry;
import xyz.phanta.tconevo.TconEvoConfig;
import xyz.phanta.tconevo.init.TconEvoItems;
import xyz.phanta.tconevo.init.TconEvoMaterials;
import xyz.phanta.tconevo.integration.ic2.EuStoreItemHandler;
import xyz.phanta.tconevo.integration.ic2.Ic2Hooks;
import xyz.phanta.tconevo.integration.ic2.Ic2Reflect;
import xyz.phanta.tconevo.item.ItemMaterial;
import xyz.phanta.tconevo.item.ItemMetal;
import xyz.phanta.tconevo.trait.ModifierPhotovoltaic;

public class Ic2HooksImpl
implements Ic2Hooks {
    private static final Ic2Hooks NOOP = new Ic2Hooks.Noop();

    @Override
    public void onPreInit(FMLPreInitializationEvent event) {
        ElectricItem.registerBackupManager((IBackupElectricItemManager)EuStoreItemHandler.INSTANCE);
    }

    @Override
    public void onInit(FMLInitializationEvent event) {
        Fluid uuMatter;
        ItemStack energiumDust = IC2Items.getItem((String)"dust", (String)"energium");
        if (energiumDust != null) {
            Recipes.cannerBottle.addRecipe(Recipes.inputFactory.forStack(ItemMaterial.Type.COALESCENCE_MATRIX.newStack(1)), Recipes.inputFactory.forStack(ItemHandlerHelper.copyStackWithSize((ItemStack)energiumDust, (int)3)), TconEvoItems.METAL.newStack(ItemMetal.Type.ENERGETIC_METAL, ItemMetal.Form.INGOT, 1), true);
        }
        if ((uuMatter = FluidRegistry.getFluid((String)"ic2uu_matter")) != null) {
            Recipes.cannerEnrich.addRecipe((Object)new ICannerEnrichRecipeManager.Input(new FluidStack(uuMatter, 72), Recipes.inputFactory.forStack(ItemMaterial.Type.COALESCENCE_MATRIX.newStack(1))), (Object)new FluidStack(TconEvoMaterials.UU_METAL.getFluid(), 144), null, true);
        }
    }

    @Override
    public void onPostInit(FMLPostInitializationEvent event) {
        ItemStack solarGen;
        Fluid superhotSteam;
        if (TconEvoConfig.moduleIndustrialCraft.fuelSuperheatedSteamBurnTime > 0 && (superhotSteam = FluidRegistry.getFluid((String)"ic2superheated_steam")) != null) {
            TinkerRegistry.registerSmelteryFuel((FluidStack)new FluidStack(superhotSteam, 50), (int)TconEvoConfig.moduleIndustrialCraft.fuelSuperheatedSteamBurnTime);
        }
        if (Ic2Reflect.canGetSolarMultiplier() && (solarGen = IC2Items.getItem((String)"te", (String)"solar_generator")) != null) {
            ModifierPhotovoltaic.registerSolarItem(solarGen, (int)Math.round(Ic2Reflect.getSolarMultiplier() * 2.5 * 20.0));
        }
    }

    @Override
    public Optional<ItemStack> getItemSolarPanel() {
        return Optional.ofNullable(IC2Items.getItem((String)"te", (String)"solar_generator"));
    }

    @Override
    public float getSunlight(World world, BlockPos pos) {
        return Ic2Reflect.canGetSkyLight() ? Ic2Reflect.getSkyLight(world, pos) : NOOP.getSunlight(world, pos);
    }

    @Override
    public boolean consumeEu(ItemStack stack, double amount, EntityLivingBase entity, boolean commit) {
        return commit ? EuStoreItemHandler.INSTANCE.use(stack, amount, entity) : EuStoreItemHandler.INSTANCE.canUse(stack, amount);
    }
}

