/*
 * Decompiled with CFR 0.152.
 */
package xyz.phanta.tconevo.integration.solarflux;

import java.util.stream.Stream;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import tk.zeitheron.solarflux.api.SolarFluxAPI;
import tk.zeitheron.solarflux.api.SolarInfo;
import xyz.phanta.tconevo.integration.solarflux.SolarCellData;
import xyz.phanta.tconevo.integration.solarflux.SolarFluxHooks;
import xyz.phanta.tconevo.trait.ModifierPhotovoltaic;

public class SolarFluxHooksImpl
implements SolarFluxHooks {
    @Override
    public void onPostInit(FMLPostInitializationEvent event) {
        for (SolarInfo info : SolarFluxAPI.SOLAR_PANELS) {
            ModifierPhotovoltaic.registerSolarItem(new ItemStack((Block)info.getBlock()), (int)Math.min(info.getGeneration() * 20L, Integer.MAX_VALUE));
        }
    }

    @Override
    public Stream<SolarCellData> getSolarTypes() {
        return SolarFluxAPI.SOLAR_PANELS.getValuesCollection().stream().map(SolarInfoWrapper::new);
    }

    private static class SolarInfoWrapper
    implements SolarCellData {
        private final SolarInfo info;

        SolarInfoWrapper(SolarInfo info) {
            this.info = info;
        }

        @Override
        public long getGenerationRate() {
            return this.info.getGeneration();
        }

        @Override
        public long getCapacity() {
            return this.info.getCapacity();
        }

        @Override
        public long getTransferRate() {
            return this.info.getTransfer();
        }

        @Override
        public ItemStack newStack(int count) {
            return new ItemStack((Block)this.info.getBlock(), count);
        }
    }
}

