/*
 * Decompiled with CFR 0.152.
 */
package xyz.phanta.tconevo.integration.thermal;

import cofh.thermalexpansion.init.TEItems;
import cofh.thermalexpansion.util.managers.machine.CrucibleManager;
import java.util.Optional;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.smeltery.MeltingRecipe;
import xyz.phanta.tconevo.TconEvoConfig;
import xyz.phanta.tconevo.TconEvoMod;
import xyz.phanta.tconevo.integration.thermal.ThermalHooks;

public class ThermalHooksImpl
implements ThermalHooks {
    @Override
    public void onPostInit(FMLPostInitializationEvent event) {
        if (TconEvoConfig.moduleThermalSeries.magmaCrucibleMeltingEnabled) {
            for (MeltingRecipe recipe : TinkerRegistry.getAllMeltingRecipies()) {
                for (ItemStack input : recipe.input.getInputs()) {
                    int energy = (int)Math.ceil((double)recipe.getTemperature() * TconEvoConfig.moduleThermalSeries.magmaCrucibleMeltingCostMultiplier);
                    if (energy > 0) {
                        this.addCrucibleRecipe(energy, input, recipe.getResult());
                        continue;
                    }
                    TconEvoMod.LOGGER.warn("Ignoring bad magma crucible recipe {} -> {}x{} with energy cost {}", (Object)input, (Object)recipe.getResult().amount, (Object)recipe.getResult().getFluid().getName(), (Object)energy);
                }
            }
        }
    }

    @Override
    public Optional<ItemStack> getItemFluxCapacitor(int tier) {
        return Optional.of(new ItemStack((Item)TEItems.itemCapacitor, 1, tier));
    }

    @Override
    public void addCrucibleRecipe(int energy, ItemStack input, FluidStack output) {
        CrucibleManager.addRecipe((int)energy, (ItemStack)input, (FluidStack)output);
    }
}

