/*
 * Decompiled with CFR 0.152.
 */
package xyz.phanta.tconevo.item;

import io.github.phantamanta44.libnine.client.model.ParameterizedItemModel;
import io.github.phantamanta44.libnine.item.L9ItemSubs;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;
import xyz.phanta.tconevo.init.TconEvoItems;

public class ItemEdible
extends L9ItemSubs
implements ParameterizedItemModel.IParamaterized {
    public static final DamageSource DMG_MEAT_INGOT = new DamageSource("meat_ingot").func_76348_h().func_151518_m();

    public ItemEdible() {
        super("edible", Type.VALUES.length);
    }

    public void getModelMutations(ItemStack stack, ParameterizedItemModel.Mutation m) {
        m.mutate("type", Type.getForStack(stack).name());
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.EAT;
    }

    public int func_77626_a(ItemStack stack) {
        return 32;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (player.func_71043_e(Type.getForStack((ItemStack)stack).alwaysEdible)) {
            player.func_184598_c(hand);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        return super.func_77659_a(world, player, hand);
    }

    public ItemStack func_77654_b(ItemStack stack, World world, EntityLivingBase eater) {
        if (eater instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)eater;
            Type type = Type.getForStack(stack);
            player.func_71024_bL().func_75122_a(type.foodPoints, type.satMultiplier);
            world.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187739_dZ, SoundCategory.PLAYERS, 0.5f, world.field_73012_v.nextFloat() * 0.1f + 0.9f);
            type.onEaten(stack, world, player);
            player.func_71029_a(StatList.func_188057_b((Item)this));
            if (player instanceof EntityPlayerMP) {
                CriteriaTriggers.field_193138_y.func_193148_a((EntityPlayerMP)player, stack);
            }
        }
        stack.func_190918_g(1);
        return stack;
    }

    public static enum Type {
        MEAT_INGOT_RAW(3, 0.6667f, false){

            @Override
            public void onEaten(ItemStack stack, World world, EntityPlayer player) {
                world.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187635_cQ, SoundCategory.PLAYERS, 1.0f, 1.5f + world.field_73012_v.nextFloat() * 0.25f);
                player.func_70097_a(DMG_MEAT_INGOT, 1.0f);
            }
        }
        ,
        MEAT_INGOT_COOKED(10, 1.2f, false){

            @Override
            public void onEaten(ItemStack stack, World world, EntityPlayer player) {
                MEAT_INGOT_RAW.onEaten(stack, world, player);
            }
        };

        public static final Type[] VALUES;
        public final int foodPoints;
        public final float satMultiplier;
        public final boolean alwaysEdible;

        public static Type getForMeta(int meta) {
            return meta >= 0 && meta < VALUES.length ? VALUES[meta] : MEAT_INGOT_RAW;
        }

        public static Type getForStack(ItemStack stack) {
            return Type.getForMeta(stack.func_77960_j());
        }

        private Type(int foodPoints, float satMultiplier, boolean alwaysEdible) {
            this.foodPoints = foodPoints;
            this.satMultiplier = satMultiplier;
            this.alwaysEdible = alwaysEdible;
        }

        public void onEaten(ItemStack stack, World world, EntityPlayer player) {
        }

        public int getMeta() {
            return this.ordinal();
        }

        public ItemStack newStack(int count) {
            return new ItemStack((Item)TconEvoItems.EDIBLE, count, this.getMeta());
        }

        static {
            VALUES = Type.values();
        }
    }
}

