/*
 * Decompiled with CFR 0.152.
 */
package xyz.phanta.tconevo.material;

import com.google.common.collect.Sets;
import io.github.phantamanta44.libnine.util.collection.Accrue;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.ModContainer;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.fluid.FluidMolten;
import slimeknights.tconstruct.library.materials.ArrowShaftMaterialStats;
import slimeknights.tconstruct.library.materials.BowMaterialStats;
import slimeknights.tconstruct.library.materials.BowStringMaterialStats;
import slimeknights.tconstruct.library.materials.ExtraMaterialStats;
import slimeknights.tconstruct.library.materials.FletchingMaterialStats;
import slimeknights.tconstruct.library.materials.HandleMaterialStats;
import slimeknights.tconstruct.library.materials.HeadMaterialStats;
import slimeknights.tconstruct.library.materials.IMaterialStats;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.library.traits.ITrait;
import xyz.phanta.tconevo.TconEvoConfig;
import xyz.phanta.tconevo.TconEvoMod;
import xyz.phanta.tconevo.handler.MaterialOverrideHandler;
import xyz.phanta.tconevo.material.MaterialDefinition;
import xyz.phanta.tconevo.material.MaterialForm;
import xyz.phanta.tconevo.material.PartType;
import xyz.phanta.tconevo.material.RegCondition;
import xyz.phanta.tconevo.material.stats.MagicMaterialStats;
import xyz.phanta.tconevo.util.CraftReflect;
import xyz.phanta.tconevo.util.LazyAccum;
import xyz.phanta.tconevo.util.TconReflect;

public class MaterialBuilder {
    private static final Set<String> blacklisted = Sets.newHashSet((Object[])TconEvoConfig.disabledMaterials);
    private static final Set<String> whitelisted = Sets.newHashSet((Object[])TconEvoConfig.forceLoadMaterials);
    private final String matId;
    private final int colour;
    private final MaterialForm form;
    private final String oreName;
    private boolean needsPriority = false;
    private final List<RegCondition> conditions = new ArrayList<RegCondition>();
    private final Map<String, IMaterialStats> materialStats = new HashMap<String, IMaterialStats>();
    private boolean craftable = false;
    private boolean castable = false;
    @Nullable
    private Supplier<Fluid> fluidGetter = null;
    private int fluidTemperature = 273;
    private final Map<PartType, LazyAccum<ITrait>> traits = new EnumMap<PartType, LazyAccum<ITrait>>(PartType.class);

    public static boolean isNotBlacklisted(String matId) {
        return !blacklisted.contains(matId);
    }

    public static boolean isNotWhitelisted(String matId) {
        return !whitelisted.contains(matId);
    }

    public MaterialBuilder(String matId, int colour, MaterialForm form, String oreName) {
        this.matId = matId;
        this.colour = colour;
        this.form = form;
        this.oreName = oreName;
    }

    public MaterialBuilder needsPriority() {
        this.needsPriority = true;
        return this;
    }

    public MaterialBuilder requires(RegCondition condition) {
        this.conditions.add(condition);
        return this;
    }

    public MaterialBuilder requiresMods(String ... mods) {
        return this.requires(new RegCondition.ModLoaded(mods));
    }

    public MaterialBuilder requiresOres(String ... oreKeys) {
        return this.requires(new RegCondition.OreDictExists(oreKeys));
    }

    public MaterialBuilder requiresMaterials(Material ... materials) {
        return this.requires(new RegCondition.MaterialVisible(materials));
    }

    public MaterialBuilder overrides(String ... matIds) {
        for (String matId : matIds) {
            this.requires(new RegCondition.MaterialCanOverride(matId));
        }
        return this;
    }

    public MaterialBuilder withStats(IMaterialStats statsObj) {
        this.materialStats.put(statsObj.getIdentifier(), statsObj);
        return this;
    }

    public MaterialBuilder withStatsHead(int durability, float miningSpeed, float attack, int harvestLevel) {
        return this.withStats((IMaterialStats)new HeadMaterialStats(durability, miningSpeed, attack, harvestLevel));
    }

    public MaterialBuilder withStatsHandle(float durabilityMultiplier, int durability) {
        return this.withStats((IMaterialStats)new HandleMaterialStats(durabilityMultiplier, durability));
    }

    public MaterialBuilder withStatsExtra(int durability) {
        return this.withStats((IMaterialStats)new ExtraMaterialStats(durability));
    }

    public MaterialBuilder withStatsBow(float drawSpeed, float range, float bonusDamage) {
        return this.withStats((IMaterialStats)new BowMaterialStats(drawSpeed, range, bonusDamage));
    }

    public MaterialBuilder withStatsBowString(float durabilityMultiplier) {
        return this.withStats((IMaterialStats)new BowStringMaterialStats(durabilityMultiplier));
    }

    public MaterialBuilder withStatsArrowShaft(float durabilityMultiplier, int bonusAmmo) {
        return this.withStats((IMaterialStats)new ArrowShaftMaterialStats(durabilityMultiplier, bonusAmmo));
    }

    public MaterialBuilder withStatsFletching(float accuracy, float durabilityMultiplier) {
        return this.withStats((IMaterialStats)new FletchingMaterialStats(accuracy, durabilityMultiplier));
    }

    public MaterialBuilder withStatsMagic(int durability, float potency, float range, int harvestLevel) {
        return this.withStats((IMaterialStats)new MagicMaterialStats(durability, potency, range, harvestLevel));
    }

    public MaterialBuilder setCraftable() {
        this.craftable = true;
        return this;
    }

    public MaterialBuilder setCastable(int fluidTemperature) {
        this.castable = true;
        this.fluidTemperature = fluidTemperature;
        return this;
    }

    public MaterialBuilder setCastable(Supplier<Fluid> fluidGetter, int fallbackTemp) {
        this.castable = true;
        this.fluidGetter = fluidGetter;
        this.fluidTemperature = fallbackTemp;
        return this;
    }

    public MaterialBuilder setCastable(Fluid fluid, int fallbackTemp) {
        return this.setCastable(() -> fluid, fallbackTemp);
    }

    public MaterialBuilder setCastable(String fluidId, int fallbackTemp) {
        return this.setCastable(() -> FluidRegistry.getFluid((String)fluidId), fallbackTemp);
    }

    public MaterialBuilder withTraits(PartType partType, LazyAccum<ITrait> traitCollector) {
        this.traits.put(partType, traitCollector);
        return this;
    }

    public MaterialBuilder withTraits(PartType partType, ITrait ... traits) {
        return this.withTraits(partType, (Accrue<ITrait> c) -> c.acceptAll((Object[])traits));
    }

    public Material build() {
        this.overrides(MaterialOverrideHandler.getOverriddenIds(this.matId).toArray(new String[0]));
        Material material = TinkerRegistry.getMaterial((String)this.matId);
        boolean notBlacklisted = MaterialBuilder.isNotBlacklisted(this.matId);
        if (material != Material.UNKNOWN) {
            if (notBlacklisted && TconEvoConfig.overrideMaterials) {
                ModContainer owningMod = TinkerRegistry.getTrace((Material)material);
                TconEvoMod.LOGGER.info("Overriding existing material {} registered by {}", (Object)material.identifier, (Object)(owningMod != null ? owningMod.getModId() : "unknown"));
                TconReflect.removeMaterial(this.matId);
                MaterialOverrideHandler.override(this.matId, material);
            } else {
                return material;
            }
        }
        material = new Material(this.matId, this.colour, true);
        TconReflect.uncancelMaterial(material.identifier);
        try {
            if (notBlacklisted) {
                material.setCraftable(this.craftable);
                if (this.castable) {
                    material.setCastable(true);
                    this.registerFluid(material);
                } else {
                    material.setCastable(false);
                }
            }
            for (IMaterialStats statsObj : this.materialStats.values()) {
                TinkerRegistry.addMaterialStats((Material)material, (IMaterialStats)statsObj);
            }
            if (notBlacklisted) {
                MaterialDefinition.register(material, this.form, this.oreName, this.conditions, this.traits);
                TinkerRegistry.addMaterial((Material)material);
                if (this.needsPriority) {
                    TconReflect.prioritizeMaterial(material);
                }
                TconReflect.overrideMaterialOwnerMod(material, (Object)TconEvoMod.INSTANCE);
            }
        }
        catch (Exception e) {
            TconEvoMod.LOGGER.error("Encountered exception while building material {}", (Object)this.matId);
            TconEvoMod.LOGGER.error("Stack trace:", (Throwable)e);
        }
        return material;
    }

    private void registerFluid(Material material) {
        Fluid fluid;
        if (this.fluidGetter != null && (fluid = this.fluidGetter.get()) != null) {
            material.setFluid(fluid);
            return;
        }
        fluid = new FluidMolten(material.identifier, material.materialTextColor);
        fluid.setTemperature(this.fluidTemperature);
        fluid.setUnlocalizedName("tconevo." + material.identifier);
        FluidRegistry.registerFluid((Fluid)fluid);
        CraftReflect.setFluidUniqueId(fluid, "tconevo:" + material.identifier);
        FluidRegistry.addBucketForFluid((Fluid)fluid);
        material.setFluid(fluid);
    }
}

